/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.aspects;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.function.Consumer;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.base.ModelToUiAspectDefinition;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.defaults.ui.aspects.types.IconType;
import org.linkki.core.vaadin.component.HasIcon;
import org.linkki.util.Consumers;

public class IconAspectDefinition
extends ModelToUiAspectDefinition<VaadinIcon> {
    public static final String NAME = "icon";
    private final IconType type;
    @CheckForNull
    private final VaadinIcon value;

    public IconAspectDefinition(IconType type, @CheckForNull VaadinIcon value) {
        this.type = type;
        this.value = value;
    }

    public Aspect<VaadinIcon> createAspect() {
        if (this.type == IconType.AUTO) {
            return this.value == null ? Aspect.of((String)NAME) : Aspect.of((String)NAME, (Object)this.value);
        }
        if (this.type == IconType.STATIC) {
            return Aspect.of((String)NAME, (Object)this.value);
        }
        return Aspect.of((String)NAME);
    }

    public Consumer<VaadinIcon> createComponentValueSetter(ComponentWrapper componentWrapper) {
        Component component = (Component)componentWrapper.getComponent();
        if (component instanceof Button) {
            return icon -> {
                Button button = (Button)component;
                button.setIcon((Component)(icon != null ? icon.create() : null));
            };
        }
        if (component instanceof HasIcon) {
            return ((HasIcon)component)::setIcon;
        }
        return Consumers.nopConsumer();
    }
}

