/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.aspects;

import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.base.ModelToUiAspectDefinition;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.binding.wrapper.WrapperType;
import org.linkki.core.defaults.ui.aspects.types.LabelType;
import org.linkki.core.ui.creation.table.GridColumnWrapper;

public class LabelAspectDefinition
extends ModelToUiAspectDefinition<String> {
    public static final String NAME = "label";
    private final String label;
    private final LabelType labelType;

    public LabelAspectDefinition(String label) {
        this(label, LabelType.STATIC);
    }

    public LabelAspectDefinition(String label, LabelType labelType) {
        this.label = label;
        this.labelType = labelType;
    }

    public Aspect<String> createAspect() {
        switch (this.labelType) {
            case AUTO: {
                return StringUtils.isEmpty((CharSequence)this.label) ? Aspect.of((String)NAME) : Aspect.of((String)NAME, (Object)this.label);
            }
            case DYNAMIC: {
                return Aspect.of((String)NAME);
            }
            case STATIC: {
                return Aspect.of((String)NAME, (Object)this.label);
            }
            case NONE: {
                return Aspect.of((String)NAME, null);
            }
        }
        throw new IllegalArgumentException("LabelType " + this.labelType + " is not supported.");
    }

    public Consumer<String> createComponentValueSetter(ComponentWrapper componentWrapper) {
        return arg_0 -> ((ComponentWrapper)componentWrapper).setLabel(arg_0);
    }

    public boolean supports(WrapperType type) {
        return super.supports(type) || GridColumnWrapper.COLUMN_TYPE.isAssignableFrom(type);
    }
}

