/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.aspects;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.listbox.ListBoxBase;
import java.util.function.Consumer;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.base.ModelToUiAspectDefinition;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.defaults.ui.aspects.EnabledAspectDefinition;
import org.linkki.core.defaults.ui.aspects.types.RequiredType;
import org.linkki.util.Consumers;

public class RequiredAspectDefinition
extends ModelToUiAspectDefinition<Boolean> {
    public static final String NAME = "required";
    private final EnabledAspectDefinition enabledAspectDefinition;
    private final RequiredType requiredType;

    public RequiredAspectDefinition(RequiredType requiredType, EnabledAspectDefinition enabledTypeAspectDefinition) {
        this.requiredType = requiredType;
        this.enabledAspectDefinition = enabledTypeAspectDefinition;
    }

    public Aspect<Boolean> createAspect() {
        switch (this.requiredType) {
            case DYNAMIC: {
                return Aspect.of((String)NAME);
            }
            case NOT_REQUIRED: {
                return Aspect.of((String)NAME, (Object)false);
            }
            case REQUIRED: {
                return Aspect.of((String)NAME, (Object)true);
            }
            case REQUIRED_IF_ENABLED: {
                return this.enabledAspectDefinition.createAspect();
            }
        }
        throw new IllegalStateException("Unknown required type: " + this.requiredType);
    }

    public Consumer<Boolean> createComponentValueSetter(ComponentWrapper componentWrapper) {
        Object component = componentWrapper.getComponent();
        if (component instanceof ListBoxBase) {
            return Consumers.nopConsumer();
        }
        if (component instanceof HasValue) {
            HasValue field = (HasValue)componentWrapper.getComponent();
            return arg_0 -> ((HasValue)field).setRequiredIndicatorVisible(arg_0);
        }
        if (this.requiredType == RequiredType.NOT_REQUIRED) {
            return Consumers.nopConsumer();
        }
        throw new IllegalArgumentException("Required type binding is not supported for a component of type " + component.getClass() + " ");
    }
}

