/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.aspects;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.shared.HasSuffix;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.base.ModelToUiAspectDefinition;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.ui.aspects.types.SuffixType;
import org.linkki.util.Consumers;

public class SuffixAspectDefinition
extends ModelToUiAspectDefinition<String> {
    public static final String NAME = "suffix";
    private final SuffixType suffixType;
    private final String value;

    public SuffixAspectDefinition(String value, SuffixType suffixType) {
        this.value = value;
        this.suffixType = suffixType;
    }

    public Aspect<String> createAspect() {
        switch (this.suffixType) {
            case DYNAMIC: {
                return Aspect.of((String)NAME);
            }
            case AUTO: {
                if (StringUtils.isEmpty((CharSequence)this.value)) {
                    return Aspect.of((String)NAME);
                }
                return Aspect.of((String)NAME, (Object)this.value);
            }
            case STATIC: {
                return Aspect.of((String)NAME, (Object)this.value);
            }
        }
        throw new IllegalStateException("Unknown suffix type: " + this.suffixType);
    }

    public Consumer<String> createComponentValueSetter(ComponentWrapper componentWrapper) {
        Object component = componentWrapper.getComponent();
        if (component instanceof HasSuffix) {
            HasSuffix field = (HasSuffix)component;
            return text -> field.setSuffixComponent((Component)new Div(new Component[]{new Text(text)}));
        }
        return Consumers.nopConsumer();
    }
}

