/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.bind.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.property.BoundProperty;
import org.linkki.core.binding.descriptor.property.annotation.BoundPropertyCreator;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.defaults.ui.aspects.types.AvailableValuesType;
import org.linkki.core.defaults.ui.aspects.types.EnabledType;
import org.linkki.core.defaults.ui.aspects.types.RequiredType;
import org.linkki.core.defaults.ui.aspects.types.VisibleType;
import org.linkki.core.ui.bind.annotation.BindAnnotationAspectDefinitionCreator;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
@LinkkiBoundProperty(value=BindAnnotationBoundPropertyCreator.class)
@LinkkiAspect(value=BindAnnotationAspectDefinitionCreator.class)
public @interface Bind {
    public String pmoProperty() default "";

    public String modelObject() default "modelObject";

    public String modelAttribute() default "";

    public EnabledType enabled() default EnabledType.ENABLED;

    public VisibleType visible() default VisibleType.VISIBLE;

    public RequiredType required() default RequiredType.NOT_REQUIRED;

    public AvailableValuesType availableValues() default AvailableValuesType.NO_VALUES;

    public static class BindAnnotationBoundPropertyCreator
    implements BoundPropertyCreator<Bind> {
        public BoundProperty createBoundProperty(Bind annotation, AnnotatedElement annotatedElement) {
            return this.getPmoProperty(annotation, annotatedElement).withModelObject(annotation.modelObject()).withModelAttribute(annotation.modelAttribute());
        }

        private BoundProperty getPmoProperty(Bind annotation, AnnotatedElement annotatedElement) {
            String pmoPropertyName = annotation.pmoProperty();
            if (StringUtils.isEmpty((CharSequence)pmoPropertyName)) {
                return BoundPropertyCreator.SimpleMemberNameBoundPropertyCreator.createBoundProperty((AnnotatedElement)annotatedElement);
            }
            return BoundProperty.of((String)pmoPropertyName);
        }
    }
}

