/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.converters;

import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.DateToLongConverter;
import com.vaadin.flow.data.converter.DateToSqlDateConverter;
import com.vaadin.flow.data.converter.LocalDateTimeToDateConverter;
import com.vaadin.flow.data.converter.LocalDateToDateConverter;
import com.vaadin.flow.data.converter.StringToBigDecimalConverter;
import com.vaadin.flow.data.converter.StringToBigIntegerConverter;
import com.vaadin.flow.data.converter.StringToBooleanConverter;
import com.vaadin.flow.data.converter.StringToDateConverter;
import com.vaadin.flow.data.converter.StringToDoubleConverter;
import com.vaadin.flow.data.converter.StringToFloatConverter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.data.converter.StringToLongConverter;
import com.vaadin.flow.server.VaadinSession;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.linkki.core.ui.converters.LocalDateTimeToStringConverter;
import org.linkki.core.ui.converters.LocalDateToStringConverter;
import org.linkki.util.Sequence;

public class LinkkiConverterRegistry
implements Serializable {
    private static final String ERROR_MESSAGE = "Error converting Value";
    private static final long serialVersionUID = 1L;
    private static final List<Converter<?, ?>> DEFAULT_CONVERTERS = Arrays.asList(new DateToLongConverter(), new DateToSqlDateConverter(), new LocalDateTimeToDateConverter(ZoneId.systemDefault()), new LocalDateToDateConverter(), new LocalDateToStringConverter(), new LocalDateTimeToStringConverter(), new StringToBigDecimalConverter("Error converting Value"), new StringToBigIntegerConverter("Error converting Value"), new StringToBooleanConverter("Error converting Value"), new StringToDateConverter(), new StringToDoubleConverter("Error converting Value"), new StringToFloatConverter("Error converting Value"), new StringToIntegerConverter("Error converting Value"), new StringToLongConverter("Error converting Value"));
    public static final LinkkiConverterRegistry DEFAULT = new LinkkiConverterRegistry(new Converter[0]);
    private final HashMap<Class<?>, Map<Class<?>, Converter<?, ?>>> converters = new HashMap();

    @SafeVarargs
    public LinkkiConverterRegistry(Converter<?, ?> ... customConverters) {
        this(Arrays.asList(customConverters));
    }

    public LinkkiConverterRegistry(Collection<Converter<?, ?>> customConverters) {
        Objects.requireNonNull(customConverters, "customConverters must not be null");
        DEFAULT_CONVERTERS.stream().forEach(this::storeConverter);
        customConverters.stream().forEach(this::storeConverter);
    }

    public LinkkiConverterRegistry(Sequence<Converter<?, ?>> customConverters) {
        this(customConverters.list());
    }

    private void storeConverter(Converter<?, ?> converter) {
        this.converters.computeIfAbsent(this.getPresentationType(converter), p -> new LinkedHashMap()).put(this.getModelType(converter), converter);
    }

    public <P, M> Converter<P, M> findConverter(Type presentationType, Type modelType) {
        Class<?> rawModelType;
        Class<?> rawPresentationType = this.getRawType(presentationType);
        if (this.isIdentityNecessary(rawPresentationType, rawModelType = this.getRawType(modelType))) {
            return Converter.identity();
        }
        Map<Class<?>, Converter<?, ?>> byPresentationType = this.converters.get(rawPresentationType);
        if (byPresentationType != null) {
            return byPresentationType.computeIfAbsent(rawModelType, mt -> this.findNextByPresentationType(byPresentationType.values(), rawPresentationType, (Type)mt));
        }
        throw new IllegalArgumentException("Cannot convert presentation type " + presentationType + " to model type " + modelType);
    }

    private Converter<?, ?> findNextByPresentationType(Collection<Converter<?, ?>> convertersByPresentationType, Type presentationType, Type modelType) {
        return convertersByPresentationType.stream().filter(c -> TypeUtils.isAssignable((Type)modelType, this.getModelType((Converter<?, ?>)c))).max((c0, c1) -> {
            boolean c0AssignableToC1 = TypeUtils.isAssignable(this.getModelType((Converter<?, ?>)c0), this.getModelType((Converter<?, ?>)c1));
            boolean c1AssignableToC0 = TypeUtils.isAssignable(this.getModelType((Converter<?, ?>)c1), this.getModelType((Converter<?, ?>)c0));
            return Boolean.compare(c0AssignableToC1, c1AssignableToC0);
        }).orElseThrow(() -> new IllegalArgumentException("Cannot convert presentation type " + presentationType + " to model type " + modelType));
    }

    private boolean isIdentityNecessary(@CheckForNull Class<?> rawPresentationType, @CheckForNull Class<?> rawModelType) {
        return rawPresentationType == null || rawModelType == null || rawPresentationType.equals(rawModelType) || Object.class.equals(rawModelType) || Object.class.equals(rawPresentationType);
    }

    @CheckForNull
    private Class<?> getRawType(@CheckForNull Type type) {
        return ClassUtils.primitiveToWrapper((Class)TypeUtils.getRawType((Type)type, null));
    }

    @CheckForNull
    private Class<?> getPresentationType(Converter<?, ?> converter) {
        return this.getTypeOf(converter, 0);
    }

    @CheckForNull
    private Class<?> getModelType(Converter<?, ?> converter) {
        return this.getTypeOf(converter, 1);
    }

    @CheckForNull
    private Class<?> getTypeOf(Converter<?, ?> converter, int index) {
        Map typeArguments = TypeUtils.getTypeArguments(converter.getClass(), Converter.class);
        TypeVariable<Class<T>>[] typeVariables = Converter.class.getTypeParameters();
        return this.getRawType((Type)typeArguments.get(typeVariables[index]));
    }

    protected Sequence<Converter<?, ?>> getAllConverters() {
        return (Sequence)this.converters.values().stream().map(Map::values).flatMap(Collection::stream).collect(Sequence.collect());
    }

    public LinkkiConverterRegistry with(Converter<?, ?> converter) {
        return new LinkkiConverterRegistry(this.getAllConverters().with((Object[])new Converter[]{converter}));
    }

    public static LinkkiConverterRegistry getCurrent() {
        return Optional.ofNullable(VaadinSession.getCurrent()).map(s -> (LinkkiConverterRegistry)s.getAttribute(LinkkiConverterRegistry.class)).orElse(DEFAULT);
    }
}

