/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.converters;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.linkki.core.uiframework.UiFramework;
import org.linkki.util.DateFormats;

public class LocalDateTimeToStringConverter
implements Converter<String, LocalDateTime> {
    private static final long serialVersionUID = -643467350091621552L;

    public Result<LocalDateTime> convertToModel(String value, ValueContext context) {
        if (value == null) {
            return Result.ok(null);
        }
        try {
            return Result.ok((Object)LocalDateTime.parse(value, this.getFormatter(context)));
        }
        catch (DateTimeParseException e) {
            return Result.error((String)e.getMessage());
        }
    }

    public String convertToPresentation(LocalDateTime value, ValueContext context) {
        if (value == null) {
            return null;
        }
        return this.getFormatter(context).format(value);
    }

    private DateTimeFormatter getFormatter(ValueContext context) {
        Locale locale = context.getLocale().orElse(UiFramework.getLocale());
        return new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern(DateFormats.getPattern((Locale)locale))).appendLiteral(' ').append(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT)).toFormatter(locale);
    }
}

