/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.converters;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import org.linkki.core.uiframework.UiFramework;
import org.linkki.util.DateFormats;

public class LocalDateToStringConverter
implements Converter<String, LocalDate> {
    private static final long serialVersionUID = 8455226862921363911L;

    public Result<LocalDate> convertToModel(String value, ValueContext context) {
        if (value == null) {
            return Result.ok(null);
        }
        try {
            return Result.ok((Object)LocalDate.parse(value, this.getFormatter(context)));
        }
        catch (DateTimeParseException e) {
            return Result.error((String)e.getMessage());
        }
    }

    public String convertToPresentation(LocalDate value, ValueContext context) {
        if (value == null) {
            return null;
        }
        return this.getFormatter(context).format(value);
    }

    private DateTimeFormatter getFormatter(ValueContext context) {
        return DateTimeFormatter.ofPattern(DateFormats.getPattern((Locale)context.getLocale().orElse(UiFramework.getLocale())));
    }
}

