/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.creation.table;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.treegrid.TreeGrid;
import java.util.Objects;
import java.util.Optional;
import org.linkki.core.binding.BindingContext;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.defaults.columnbased.pmo.ContainerPmo;
import org.linkki.core.ui.ComponentStyles;
import org.linkki.core.ui.creation.table.AbstractGridComponentWrapper;
import org.linkki.core.ui.creation.table.GridComponentDefinition;
import org.linkki.core.ui.creation.table.GridComponentWrapper;
import org.linkki.core.ui.creation.table.GridLayoutDefinition;
import org.linkki.core.ui.creation.table.TreeGridComponentWrapper;
import org.linkki.core.uicreation.UiCreator;

public class GridComponentCreator {
    private static final String TABLE_ID_SUFFIX = "_table";

    private GridComponentCreator() {
    }

    public static <ROW> Grid<ROW> createGrid(ContainerPmo<ROW> containerPmo, BindingContext bindingContext) {
        Objects.requireNonNull(containerPmo, "containerPmo must not be null");
        Objects.requireNonNull(bindingContext, "bindingContext must not be null");
        Grid grid = ((AbstractGridComponentWrapper)UiCreator.createComponent(containerPmo, (BindingContext)bindingContext, (LinkkiComponentDefinition)new GridComponentDefinition(GridVariant.LUMO_WRAP_CELL_CONTENT, GridVariant.LUMO_COMPACT, GridVariant.LUMO_NO_BORDER), c -> GridComponentCreator.createComponentWrapper(containerPmo, c), Optional.of(new GridLayoutDefinition()))).getComponent();
        grid.setId(containerPmo.getClass().getSimpleName() + TABLE_ID_SUFFIX);
        ComponentStyles.setOverflowAuto(grid);
        return grid;
    }

    public static AbstractGridComponentWrapper<?> createComponentWrapper(ContainerPmo<?> containerPmo, Object grid) {
        if (containerPmo.isHierarchical()) {
            return new TreeGridComponentWrapper((TreeGrid)grid);
        }
        return new GridComponentWrapper((Grid)grid);
    }
}

