/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.element.annotation;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Optional;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.binding.descriptor.property.annotation.BoundPropertyCreator;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.defaults.ui.aspects.EnabledAspectDefinition;
import org.linkki.core.defaults.ui.aspects.VisibleAspectDefinition;
import org.linkki.core.defaults.ui.aspects.types.CaptionType;
import org.linkki.core.defaults.ui.aspects.types.EnabledType;
import org.linkki.core.defaults.ui.aspects.types.VisibleType;
import org.linkki.core.ui.aspects.ButtonInvokeAspectDefinition;
import org.linkki.core.ui.aspects.CaptionAspectDefinition;
import org.linkki.core.ui.aspects.LabelAspectDefinition;
import org.linkki.core.uicreation.ComponentDefinitionCreator;
import org.linkki.core.uicreation.LinkkiPositioned;
import org.linkki.core.vaadin.component.ComponentFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@LinkkiBoundProperty(value=BoundPropertyCreator.SimpleMemberNameBoundPropertyCreator.class)
@LinkkiComponent(value=ButtonComponentDefinitionCreator.class)
@LinkkiAspect(value=ButtonAspectCreator.class)
@LinkkiPositioned
public @interface UIButton {
    @LinkkiPositioned.Position
    public int position();

    public String label() default "";

    public String caption() default "derived.by.linkki";

    public CaptionType captionType() default CaptionType.STATIC;

    public EnabledType enabled() default EnabledType.ENABLED;

    public VisibleType visible() default VisibleType.VISIBLE;

    public VaadinIcon icon() default VaadinIcon.PLUS;

    public boolean showIcon() default false;

    public ButtonVariant[] variants() default {};

    public String[] shortcutKeyCode() default {};

    public KeyModifier[] shortcutKeyModifiers() default {};

    public static class ButtonComponentDefinitionCreator
    implements ComponentDefinitionCreator<UIButton> {
        public LinkkiComponentDefinition create(UIButton annotation, AnnotatedElement annotatedElement) {
            return pmo -> {
                Button button = ComponentFactory.newButton();
                if (annotation.showIcon()) {
                    button.setIcon((Component)annotation.icon().create());
                }
                button.addThemeVariants((ThemeVariant[])annotation.variants());
                this.createShortcutKey(annotation).ifPresent(key -> button.addClickShortcut(key, annotation.shortcutKeyModifiers()));
                return button;
            };
        }

        Optional<Key> createShortcutKey(UIButton annotation) {
            String[] keys = annotation.shortcutKeyCode();
            if (keys.length == 1) {
                return Optional.of(Key.of((String)keys[0], (String[])new String[0]));
            }
            if (keys.length > 1) {
                String[] additionalKeys = Arrays.copyOfRange(keys, 1, keys.length);
                return Optional.of(Key.of((String)keys[0], (String[])additionalKeys));
            }
            return Optional.empty();
        }
    }

    public static class ButtonAspectCreator
    implements AspectDefinitionCreator<UIButton> {
        public LinkkiAspectDefinition create(UIButton annotation) {
            return new CompositeAspectDefinition(new LinkkiAspectDefinition[]{new LabelAspectDefinition(annotation.label()), new EnabledAspectDefinition(annotation.enabled()), new VisibleAspectDefinition(annotation.visible()), new CaptionAspectDefinition(annotation.captionType(), annotation.caption()), new ButtonInvokeAspectDefinition()});
        }
    }
}

