/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.element.annotation;

import com.vaadin.flow.component.combobox.ComboBoxBase;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.defaults.ui.aspects.EnabledAspectDefinition;
import org.linkki.core.defaults.ui.aspects.VisibleAspectDefinition;
import org.linkki.core.defaults.ui.aspects.types.AvailableValuesType;
import org.linkki.core.defaults.ui.aspects.types.EnabledType;
import org.linkki.core.defaults.ui.aspects.types.RequiredType;
import org.linkki.core.defaults.ui.aspects.types.VisibleType;
import org.linkki.core.defaults.ui.element.ItemCaptionProvider;
import org.linkki.core.ui.aspects.AvailableValuesAspectDefinition;
import org.linkki.core.ui.aspects.DerivedReadOnlyAspectDefinition;
import org.linkki.core.ui.aspects.LabelAspectDefinition;
import org.linkki.core.ui.aspects.RequiredAspectDefinition;
import org.linkki.core.ui.aspects.ValueAspectDefinition;
import org.linkki.core.uicreation.ComponentDefinitionCreator;
import org.linkki.core.uicreation.LinkkiPositioned;
import org.linkki.core.vaadin.component.ComponentFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@LinkkiBoundProperty
@LinkkiComponent(value=MultiSelectComponentDefinitionCreator.class)
@LinkkiAspect(value=MultiSelectAspectCreator.class)
@LinkkiPositioned
public @interface UIMultiSelect {
    @LinkkiPositioned.Position
    public int position();

    public String label() default "derived.by.linkki";

    public EnabledType enabled() default EnabledType.ENABLED;

    public RequiredType required() default RequiredType.NOT_REQUIRED;

    public VisibleType visible() default VisibleType.VISIBLE;

    public String width() default "-1px";

    @LinkkiBoundProperty.ModelObjectProperty
    public String modelObject() default "modelObject";

    @LinkkiBoundProperty.ModelAttribute
    public String modelAttribute() default "";

    public Class<? extends ItemCaptionProvider<?>> itemCaptionProvider() default ItemCaptionProvider.DefaultCaptionProvider.class;

    public static class MultiSelectComponentDefinitionCreator
    implements ComponentDefinitionCreator<UIMultiSelect> {
        public LinkkiComponentDefinition create(UIMultiSelect annotation, AnnotatedElement annotatedElement) {
            return pmo -> {
                MultiSelectComboBox multiselect = ComponentFactory.newMultiSelect();
                multiselect.setClearButtonVisible(true);
                multiselect.setItemLabelGenerator(arg_0 -> ((ItemCaptionProvider)ItemCaptionProvider.instantiate(annotation::itemCaptionProvider)).getUnsafeCaption(arg_0));
                multiselect.setWidth(annotation.width());
                return multiselect;
            };
        }
    }

    public static class MultiSelectAspectCreator
    implements AspectDefinitionCreator<UIMultiSelect> {
        public LinkkiAspectDefinition create(UIMultiSelect annotation) {
            AvailableValuesAspectDefinition<MultiSelectComboBox> availableValuesAspectDefinition = new AvailableValuesAspectDefinition<MultiSelectComboBox>(AvailableValuesType.DYNAMIC, ComboBoxBase::setItems);
            EnabledAspectDefinition enabledAspectDefinition = new EnabledAspectDefinition(annotation.enabled());
            RequiredAspectDefinition requiredAspectDefinition = new RequiredAspectDefinition(annotation.required(), enabledAspectDefinition);
            return new CompositeAspectDefinition(new LinkkiAspectDefinition[]{new LabelAspectDefinition(annotation.label()), enabledAspectDefinition, requiredAspectDefinition, availableValuesAspectDefinition, new VisibleAspectDefinition(annotation.visible()), new ValueAspectDefinition(), new DerivedReadOnlyAspectDefinition()});
        }
    }
}

