/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.layout.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import org.linkki.core.binding.descriptor.property.annotation.BoundPropertyCreator;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.binding.dispatcher.staticvalue.StaticValueNlsService;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.ui.creation.section.SectionLayoutDefinition;
import org.linkki.core.uicreation.ComponentDefinitionCreator;
import org.linkki.core.uicreation.layout.LayoutDefinitionCreator;
import org.linkki.core.uicreation.layout.LinkkiLayout;
import org.linkki.core.uicreation.layout.LinkkiLayoutDefinition;
import org.linkki.core.vaadin.component.section.BaseSection;

@LinkkiComponent(value=SectionComponentDefinitonCreator.class)
@LinkkiLayout(value=SectionLayoutDefinitionCreator.class)
@LinkkiBoundProperty(value=BoundPropertyCreator.EmptyPropertyCreator.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface UIFormSection {
    public String caption() default "";

    public boolean closeable() default false;

    public int columns() default 1;

    public static class SectionLayoutDefinitionCreator
    implements LayoutDefinitionCreator<UIFormSection> {
        public LinkkiLayoutDefinition create(UIFormSection annotation, AnnotatedElement annotatedElement) {
            return SectionLayoutDefinition.DEFAULT;
        }
    }

    public static class SectionComponentDefinitonCreator
    implements ComponentDefinitionCreator<UIFormSection> {
        public LinkkiComponentDefinition create(UIFormSection uiFormSection, AnnotatedElement annotatedElement) {
            return pmo -> {
                String label = StaticValueNlsService.getInstance().getString(pmo.getClass(), "", "caption", uiFormSection.caption());
                BaseSection baseSection = new BaseSection(label, uiFormSection.closeable(), uiFormSection.columns());
                baseSection.getElement().getThemeList().add((Object)"form");
                return baseSection;
            };
        }
    }
}

