/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.table.aspects;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.selection.SingleSelect;
import java.io.Serializable;
import java.util.Objects;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.dispatcher.PropertyDispatcher;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.binding.wrapper.WrapperType;
import org.linkki.core.defaults.columnbased.ColumnBasedComponentWrapper;
import org.linkki.util.handler.Handler;

public class GridSelectionAspectDefinition
implements LinkkiAspectDefinition {
    public static final String SELECTION_ASPECT_NAME = "selection";
    public static final String DOUBLE_CLICK_ASPECT_NAME = "onDoubleClick";

    public void initModelUpdate(PropertyDispatcher propertyDispatcher, ComponentWrapper componentWrapper, Handler modelChanged) {
        Grid grid = (Grid)componentWrapper.getComponent();
        grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        SingleSelect singleSelect = grid.asSingleSelect();
        singleSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            Object newSelection = e.getValue();
            if (newSelection != null) {
                propertyDispatcher.push(Aspect.of((String)SELECTION_ASPECT_NAME, (Object)newSelection));
            }
            modelChanged.apply();
        });
        grid.addItemDoubleClickListener((ComponentEventListener & Serializable)e -> {
            Object clickedItem = e.getItem();
            if (singleSelect.getOptionalValue().map(v -> !Objects.equals(v, clickedItem)).orElse(true).booleanValue()) {
                propertyDispatcher.push(Aspect.of((String)SELECTION_ASPECT_NAME, (Object)e.getItem()));
            }
            propertyDispatcher.push(Aspect.of((String)DOUBLE_CLICK_ASPECT_NAME));
            modelChanged.apply();
        });
    }

    public Handler createUiUpdater(PropertyDispatcher propertyDispatcher, ComponentWrapper componentWrapper) {
        Object component = componentWrapper.getComponent();
        if (component instanceof Grid) {
            SingleSelect grid = ((Grid)componentWrapper.getComponent()).asSingleSelect();
            return () -> grid.setValue(propertyDispatcher.pull(Aspect.of((String)SELECTION_ASPECT_NAME)));
        }
        return Handler.NOP_HANDLER;
    }

    public boolean supports(WrapperType type) {
        return ColumnBasedComponentWrapper.COLUMN_BASED_TYPE.isAssignableFrom(type);
    }
}

