/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.table.column.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.ui.aspects.types.TextAlignment;
import org.linkki.core.ui.table.aspects.ColumnSortableAspectDefinition;
import org.linkki.core.ui.table.aspects.ColumnTextAlignAspectDefinition;
import org.linkki.core.ui.table.column.aspects.ColumnCollapseAspectDefinition;
import org.linkki.core.ui.table.column.aspects.ColumnFlexGrowAspectDefinition;
import org.linkki.core.ui.table.column.aspects.ColumnWidthAspectDefinition;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@LinkkiAspect(value=TableColumnAspectDefinitionCreator.class)
public @interface UITableColumn {
    public static final int UNDEFINED_WIDTH = -1;
    public static final int UNDEFINED_FLEX_GROW = -1;

    public int width() default -1;

    public int flexGrow() default -1;

    public CollapseMode collapsible() default CollapseMode.NOT_COLLAPSIBLE;

    public TextAlignment textAlign() default TextAlignment.DEFAULT;

    public boolean sortable() default false;

    public static class TableColumnAspectDefinitionCreator
    implements AspectDefinitionCreator<UITableColumn> {
        public LinkkiAspectDefinition create(UITableColumn annotation) {
            int flexGrow = annotation.flexGrow();
            int width = annotation.width();
            return new CompositeAspectDefinition(new LinkkiAspectDefinition[]{new ColumnCollapseAspectDefinition(annotation.collapsible()), new ColumnFlexGrowAspectDefinition(flexGrow), new ColumnWidthAspectDefinition(width), new ColumnTextAlignAspectDefinition(annotation.textAlign()), new ColumnSortableAspectDefinition(annotation.sortable())});
        }
    }

    public static enum CollapseMode {
        NOT_COLLAPSIBLE(false, false),
        COLLAPSIBLE(true, false),
        INITIALLY_COLLAPSED(true, true);

        private final boolean collapsible;
        private final boolean initiallyCollapsed;

        private CollapseMode(boolean collapsible, boolean initiallyCollapsed) {
            this.collapsible = collapsible;
            this.initiallyCollapsed = initiallyCollapsed;
        }

        public boolean isCollapsible() {
            return this.collapsible;
        }

        public boolean isInitiallyCollapsed() {
            return this.initiallyCollapsed;
        }
    }
}

