/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.util;

import com.vaadin.flow.component.icon.Icon;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public class HtmlSanitizer {
    private HtmlSanitizer() {
    }

    @CheckForNull
    public static String sanitizeText(@CheckForNull String htmlText) {
        if (StringUtils.isEmpty((CharSequence)htmlText)) {
            return htmlText;
        }
        return Jsoup.clean((String)htmlText, (Safelist)HtmlSanitizer.createHtmlWhitelist());
    }

    @CheckForNull
    public static String escapeText(@CheckForNull String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    private static Safelist createHtmlWhitelist() {
        Safelist whitelist = Safelist.basicWithImages();
        String styleAttribute = "style";
        String classAttribute = "class";
        String idAttribute = "id";
        whitelist.addAttributes("div", new String[]{styleAttribute, classAttribute, idAttribute});
        whitelist.addAttributes("b", new String[]{styleAttribute});
        whitelist.addAttributes("em", new String[]{styleAttribute});
        whitelist.addAttributes("i", new String[]{styleAttribute});
        whitelist.addAttributes("strong", new String[]{styleAttribute});
        whitelist.addAttributes("u", new String[]{styleAttribute});
        String vaadinIconTag = new Icon().getElement().getTag();
        whitelist.addTags(new String[]{vaadinIconTag});
        whitelist.addAttributes(vaadinIconTag, new String[]{styleAttribute, classAttribute, idAttribute, "width", "height", "icon"});
        whitelist.removeProtocols("img", "src", new String[]{"http", "https"});
        return whitelist;
    }
}

