/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.vaadin.component.base;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.HasPrefix;
import com.vaadin.flow.component.shared.HasSuffix;
import com.vaadin.flow.dom.Element;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.linkki.core.ui.aspects.types.IconPosition;
import org.linkki.core.util.HtmlSanitizer;
import org.linkki.core.vaadin.component.HasIcon;

@Tag(value="linkki-text")
@JsModule(value="./src/linkki-text.ts")
public class LinkkiText
extends Component
implements HasIcon,
HasPrefix,
HasSuffix,
HasText {
    public static final String CLASS_NAME = "linkki-text";
    protected static final String ICON_CLASS_NAME = "linkki-text-icon";
    private static final long serialVersionUID = -1027646873177686722L;
    private static final String INNER_HTML_PROPERTY = "innerHTML";
    private final HasText content;
    @CheckForNull
    private VaadinIcon icon;
    @CheckForNull
    private IconPosition iconPosition = IconPosition.LEFT;

    public LinkkiText() {
        this("", null);
    }

    public LinkkiText(String text, @CheckForNull VaadinIcon icon) {
        this((HasText)new Span(), text, icon);
    }

    protected LinkkiText(HasText content, String text, @CheckForNull VaadinIcon icon) {
        this.addClassName(CLASS_NAME);
        this.content = content;
        this.getElement().appendChild(new Element[]{content.getElement()});
        this.setText(text);
        if (icon != null) {
            this.setIcon(icon);
        }
    }

    protected HasText getContent() {
        return this.content;
    }

    public String getText() {
        String innerHTML = this.getContent().getElement().getProperty(INNER_HTML_PROPERTY);
        if (innerHTML != null) {
            return innerHTML;
        }
        return this.getContent().getText();
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    public void setText(String text, boolean html) {
        if (html) {
            String sanitizedText = HtmlSanitizer.sanitizeText(text);
            this.getContent().setText(null);
            this.getContent().getElement().setProperty(INNER_HTML_PROPERTY, sanitizedText);
        } else {
            this.getContent().getElement().removeProperty(INNER_HTML_PROPERTY);
            this.getContent().setText(text);
        }
    }

    @CheckForNull
    public IconPosition getIconPosition() {
        return this.iconPosition;
    }

    public void setIconPosition(@CheckForNull IconPosition position) {
        this.iconPosition = position;
    }

    @Override
    @CheckForNull
    public VaadinIcon getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(@Nullable VaadinIcon icon) {
        if (!Objects.equals(this.icon, icon)) {
            this.icon = icon;
            this.setIconOnComponent(icon);
        }
    }

    protected void setIconOnComponent(@CheckForNull VaadinIcon icon) {
        Consumer<Icon> iconConsumer = IconPosition.RIGHT == this.iconPosition ? arg_0 -> ((LinkkiText)this).setSuffixComponent(arg_0) : arg_0 -> ((LinkkiText)this).setPrefixComponent(arg_0);
        this.setIconOnComponent(icon, iconConsumer);
    }

    protected void setIconOnComponent(@CheckForNull VaadinIcon icon, Consumer<Icon> iconConsumer) {
        Optional.ofNullable(icon).ifPresentOrElse(vIcon -> {
            Icon theIcon = vIcon.create();
            theIcon.setClassName(ICON_CLASS_NAME);
            iconConsumer.accept(theIcon);
        }, () -> iconConsumer.accept(null));
    }
}

