/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.vaadin.component.section;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.linkki.core.ui.table.column.annotation.UITableColumn;
import org.linkki.core.vaadin.component.section.LinkkiSection;

public class GridSection
extends LinkkiSection {
    private static final long serialVersionUID = 1L;
    private static final String COLMENU_ID_PREFIX = "colmenu";
    private final MenuBar menuBar = new MenuBar();

    public GridSection(String caption, boolean closeable) {
        super(caption, closeable, 1);
    }

    public Grid<?> getGrid() {
        return (Grid)this.getContentWrapper().getComponentAt(0);
    }

    public void setGrid(Grid<?> grid) {
        Objects.requireNonNull(grid, "grid must not be null");
        this.getContentWrapper().replace(this.getContentWrapper().getComponentCount() > 0 ? this.getContentWrapper().getComponentAt(0) : null, grid);
        this.addRightHeaderComponent((Component)this.createColumnCollapseToggleMenu(grid));
    }

    private MenuBar createColumnCollapseToggleMenu(Grid<?> grid) {
        this.menuBar.removeAll();
        this.menuBar.addThemeVariants((ThemeVariant[])new MenuBarVariant[]{MenuBarVariant.LUMO_ICON, MenuBarVariant.LUMO_TERTIARY_INLINE});
        MenuItem toggleItem = this.menuBar.addItem((Component)VaadinIcon.MENU.create());
        grid.getColumns().stream().filter(this::isColumnCollapsible).forEach(column -> this.addSubMenuItem(toggleItem, (Grid.Column<?>)column));
        if (((SubMenu)toggleItem.getSubMenu()).getItems().isEmpty()) {
            this.menuBar.setVisible(false);
        }
        return this.menuBar;
    }

    private Boolean isColumnCollapsible(Grid.Column<?> column) {
        return Optional.ofNullable((UITableColumn.CollapseMode)((Object)ComponentUtil.getData(column, UITableColumn.CollapseMode.class))).map(UITableColumn.CollapseMode::isCollapsible).orElse(false);
    }

    private void addSubMenuItem(MenuItem toggleItem, Grid.Column<?> column) {
        String header = Optional.ofNullable(ComponentUtil.getData(column, (String)"header")).map(String::valueOf).orElse("");
        MenuItem columnItem = (MenuItem)((SubMenu)toggleItem.getSubMenu()).addItem(header);
        columnItem.setId(this.getMenuItemKey(column));
        columnItem.setCheckable(true);
        columnItem.setChecked(column.isVisible());
        columnItem.addClickListener((ComponentEventListener & Serializable)event -> this.setColumnVisible(column.getKey(), !column.isVisible()));
    }

    public void setColumnVisible(String columnKey, boolean visible) {
        Optional.ofNullable(this.getGrid().getColumnByKey(columnKey)).ifPresent(column -> {
            column.setVisible(visible);
            ((SubMenu)((MenuItem)this.menuBar.getItems().get(0)).getSubMenu()).getItems().stream().filter(menuItem -> this.getMenuItemKey((Grid.Column<?>)column).contentEquals(menuItem.getId().orElse(""))).findFirst().ifPresent(i -> i.setChecked(visible));
        });
    }

    private String getMenuItemKey(Grid.Column<?> column) {
        return "colmenu-" + column.getKey();
    }

    @Deprecated(since="2.0.0")
    public Grid<?> getSectionContent() {
        return this.getGrid();
    }

    public String toString() {
        return "GridSection based on " + (this.getGrid() == null ? null : this.getGrid().getId());
    }
}

