/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.vaadin.component.section;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.dom.Element;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.vaadin.component.ComponentFactory;
import org.linkki.core.vaadin.component.HasCaption;
import org.linkki.util.handler.Handler;

@Tag(value="linkki-section")
@CssImport(value="./styles/linkki-section.css")
@JsModule(value="./src/linkki-section.ts")
public class LinkkiSection
extends HtmlComponent
implements HasCaption {
    public static final String CLASS_SECTION_STYLE_CARD = "section-style-card";
    public static final String CLASS_SECTION_SECONDARY_CAPTION = "section-style-secondary-caption";
    public static final String THEME_VARIANT_HORIZONTAL = "horizontal";
    public static final String THEME_VARIANT_FORM = "form";
    static final String SLOT_HEADER_COMPONENTS = "header-components";
    static final String SLOT_CLOSE_TOGGLE = "close-toggle";
    static final String SLOT_RIGHT_HEADER_COMPONENTS = "right-header-components";
    static final String SLOT_CONTENT = "content";
    private static final long serialVersionUID = 1L;
    private final H4 captionLabel = LinkkiSection.createCaption();
    private final Button closeButton;
    private final Div content;
    private boolean open = true;

    public LinkkiSection(@CheckForNull String caption) {
        this(caption, false, 1);
    }

    public LinkkiSection(@CheckForNull String caption, boolean closeable, int columns) {
        this.captionLabel.getElement().setAttribute("slot", SLOT_HEADER_COMPONENTS);
        this.closeButton = LinkkiSection.createOpenCloseButton(this::switchOpenStatus);
        this.closeButton.setVisible(closeable);
        this.closeButton.getElement().setAttribute("slot", SLOT_CLOSE_TOGGLE);
        this.setCaption(caption);
        this.content = new Div();
        this.content.getElement().setAttribute("slot", SLOT_CONTENT);
        this.getElement().appendChild(new Element[]{this.captionLabel.getElement(), this.closeButton.getElement(), this.content.getElement()});
        if (columns > 1) {
            this.getElement().getThemeList().add((Object)THEME_VARIANT_HORIZONTAL);
        }
        this.getStyle().set("--columns", String.valueOf(columns));
    }

    private static H4 createCaption() {
        H4 h4 = new H4();
        h4.addClassName("linkki-section-caption-text");
        return h4;
    }

    private static Button createOpenCloseButton(Handler toggleCloseOpen) {
        Button button = ComponentFactory.newButton(VaadinIcon.ANGLE_DOWN.create(), Collections.emptyList());
        button.addClickListener((ComponentEventListener & Serializable)e -> toggleCloseOpen.apply());
        button.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
        return button;
    }

    @Override
    public void setCaption(@CheckForNull String caption) {
        this.captionLabel.setText(caption);
        this.captionLabel.setVisible(!StringUtils.isEmpty((CharSequence)caption));
    }

    @Override
    public String getCaption() {
        return this.captionLabel.getText();
    }

    public void addHeaderButton(Button button) {
        this.addComponentToHeaderLayout((Component)button, SLOT_HEADER_COMPONENTS, true);
    }

    public void addHeaderComponent(Component component) {
        this.addComponentToHeaderLayout(component, SLOT_HEADER_COMPONENTS, false);
    }

    public void addRightHeaderComponent(Component component) {
        this.addComponentToHeaderLayout(component, SLOT_RIGHT_HEADER_COMPONENTS, false);
    }

    private void addComponentToHeaderLayout(Component component, String slot, boolean insertLeft) {
        if (component instanceof Button) {
            ((Button)component).addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
        }
        component.getElement().setAttribute("slot", slot);
        if (insertLeft) {
            this.getElement().insertChild(1, new Element[]{component.getElement()});
        } else {
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    public List<Component> getHeaderComponents() {
        return this.getChildren().filter(c -> SLOT_HEADER_COMPONENTS.contentEquals(c.getElement().getAttribute("slot"))).collect(Collectors.toList());
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void open() {
        if (this.isOpen()) {
            return;
        }
        this.switchOpenStatus();
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.switchOpenStatus();
    }

    protected void switchOpenStatus() {
        this.open = !this.open;
        this.closeButton.setIcon((Component)(this.open ? VaadinIcon.ANGLE_DOWN.create() : VaadinIcon.ANGLE_RIGHT.create()));
        this.getContentWrapper().setVisible(this.open);
    }

    @Deprecated(since="2.0.0")
    protected Component getSectionContent() {
        return this.content;
    }

    public Div getContentWrapper() {
        return this.content;
    }
}

