/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.aspects;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasValue;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.dispatcher.PropertyDispatcher;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.ui.aspects.types.ReadOnlyBehaviorType;
import org.linkki.util.handler.Handler;

public class BindReadOnlyBehaviorAspectDefinition
implements LinkkiAspectDefinition {
    private final ReadOnlyBehaviorType value;

    public BindReadOnlyBehaviorAspectDefinition(ReadOnlyBehaviorType value) {
        this.value = value;
    }

    public Handler createUiUpdater(PropertyDispatcher propertyDispatcher, ComponentWrapper componentWrapper) {
        return () -> this.setComponentStatus(componentWrapper, propertyDispatcher.isPushable(Aspect.of((String)"")));
    }

    private void setComponentStatus(ComponentWrapper componentWrapper, boolean writable) {
        Component component = (Component)componentWrapper.getComponent();
        switch (this.value) {
            case DISABLED: {
                HasEnabled enableComponent = (HasEnabled)component;
                componentWrapper.setEnabled(enableComponent.isEnabled() && writable);
                break;
            }
            case INVISIBLE: {
                componentWrapper.setVisible(component.isVisible() && writable);
                break;
            }
            case WRITABLE: {
                if (!(component instanceof HasValue)) break;
                ((HasValue)component).setReadOnly(false);
                break;
            }
            case INVISIBLE_IF_WRITABLE: {
                componentWrapper.setVisible(component.isVisible() && !writable);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ReadOnlyBehaviorType " + this.value);
            }
        }
    }
}

