/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.aspects;

import com.vaadin.flow.component.HasStyle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.binding.LinkkiBindingException;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.base.ModelToUiAspectDefinition;
import org.linkki.core.binding.dispatcher.PropertyDispatcher;
import org.linkki.core.binding.wrapper.ComponentWrapper;

public class BindStyleNamesAspectDefinition
extends ModelToUiAspectDefinition<Object> {
    public static final String NAME = "styleNames";
    private final boolean dynamic;
    private final List<String> staticStyleNames;

    public BindStyleNamesAspectDefinition(String ... styleNames) {
        this.staticStyleNames = Arrays.asList(styleNames);
        this.dynamic = styleNames.length == 0;
    }

    public Aspect<Object> createAspect() {
        return this.dynamic ? Aspect.of((String)NAME) : Aspect.of((String)NAME, this.staticStyleNames);
    }

    protected void handleUiUpdateException(RuntimeException e, PropertyDispatcher propertyDispatcher, Aspect<Object> aspect) {
        if (e instanceof ClassCastException) {
            throw new LinkkiBindingException("The return type of the method get" + StringUtils.capitalize((String)propertyDispatcher.getProperty()) + StringUtils.capitalize((String)NAME) + " must be either String or Collection<String>", (Exception)e);
        }
        super.handleUiUpdateException(e, propertyDispatcher, aspect);
    }

    public Consumer<Object> createComponentValueSetter(ComponentWrapper componentWrapper) {
        Object wrappedComponent = componentWrapper.getComponent();
        if (!(wrappedComponent instanceof HasStyle)) {
            throw new IllegalArgumentException(String.format("Could not set styles names. Component %s must implement %s interface.", wrappedComponent.getClass().getName(), HasStyle.class.getName()));
        }
        HasStyle component = (HasStyle)wrappedComponent;
        String predefinedStyleNames = component.getClassName();
        return styleNames -> {
            if (styleNames instanceof String) {
                this.setClassName(component, predefinedStyleNames, (String)styleNames);
            } else {
                String joinedStyleNames = String.join((CharSequence)" ", (Collection)styleNames);
                this.setClassName(component, predefinedStyleNames, joinedStyleNames);
            }
        };
    }

    private void setClassName(HasStyle component, String predefinedStyleNames, String styleNames) {
        if (predefinedStyleNames != null) {
            component.setClassName(predefinedStyleNames + " " + styleNames);
        } else {
            component.setClassName(styleNames);
        }
    }
}

