/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.aspects;

import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.checkbox.Checkbox;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.base.ModelToUiAspectDefinition;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.binding.wrapper.WrapperType;
import org.linkki.core.defaults.columnbased.ColumnBasedComponentWrapper;
import org.linkki.core.defaults.ui.aspects.types.CaptionType;
import org.linkki.core.vaadin.component.HasCaption;
import org.linkki.util.Consumers;

public class CaptionAspectDefinition
extends ModelToUiAspectDefinition<String> {
    public static final String NAME = "caption";
    private final CaptionType captionType;
    private final String staticCaption;

    public CaptionAspectDefinition(CaptionType captionType, String staticCaption) {
        this.captionType = captionType;
        this.staticCaption = staticCaption;
    }

    public Aspect<String> createAspect() {
        switch (this.captionType) {
            case AUTO: {
                return StringUtils.isEmpty((CharSequence)this.staticCaption) ? Aspect.of((String)NAME) : Aspect.of((String)NAME, (Object)this.staticCaption);
            }
            case DYNAMIC: {
                return Aspect.of((String)NAME);
            }
            case STATIC: {
                return Aspect.of((String)NAME, (Object)this.staticCaption);
            }
            case NONE: {
                return Aspect.of((String)NAME, null);
            }
        }
        throw new IllegalArgumentException("CaptionType " + this.captionType + " is not supported.");
    }

    public Consumer<String> createComponentValueSetter(ComponentWrapper componentWrapper) {
        Object component = componentWrapper.getComponent();
        if (component instanceof HasCaption) {
            return caption -> ((HasCaption)component).setCaption((String)caption);
        }
        if (component instanceof HasText) {
            return caption -> ((HasText)component).setText(caption);
        }
        if (component instanceof Checkbox) {
            return caption -> ((Checkbox)component).setLabel(caption);
        }
        return Consumers.nopConsumer();
    }

    public boolean supports(WrapperType type) {
        return super.supports(type) && !ColumnBasedComponentWrapper.COLUMN_BASED_TYPE.isAssignableFrom(type);
    }
}

