/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.aspects;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.base.ModelToUiAspectDefinition;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.ui.aspects.types.PlaceholderType;

public class PlaceholderAspectDefinition
extends ModelToUiAspectDefinition<String> {
    public static final String NAME = "placeholder";
    public static final String HAS_PLACEHOLDER = "has-placeholder";
    private final String value;
    private final PlaceholderType type;

    public PlaceholderAspectDefinition(String value, PlaceholderType type) {
        this.value = value;
        this.type = type;
    }

    public Aspect<String> createAspect() {
        switch (this.type) {
            case DYNAMIC: {
                return Aspect.of((String)NAME);
            }
            case AUTO: {
                if (StringUtils.isEmpty((CharSequence)this.value)) {
                    return Aspect.of((String)NAME);
                }
                return Aspect.of((String)NAME, (Object)this.value);
            }
            case STATIC: {
                return Aspect.of((String)NAME, (Object)this.value);
            }
        }
        throw new IllegalStateException("Unknown placeholder type: " + this.type);
    }

    public Consumer<String> createComponentValueSetter(ComponentWrapper componentWrapper) {
        Component component = (Component)componentWrapper.getComponent();
        return placeholder -> {
            if (component instanceof Grid) {
                component.getElement().getStyle().set("--placeholder", "'" + placeholder + "'");
                component.getElement().setAttribute(HAS_PLACEHOLDER, placeholder != null);
            } else {
                component.getElement().setProperty(NAME, placeholder == null ? "" : placeholder);
            }
        };
    }
}

