/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.aspects;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableConsumer;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.dispatcher.PropertyDispatcher;
import org.linkki.core.binding.validation.message.Message;
import org.linkki.core.binding.validation.message.MessageList;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.ui.converters.LinkkiConverterRegistry;
import org.linkki.core.ui.nls.NlsText;
import org.linkki.core.uiframework.UiFramework;
import org.linkki.util.handler.Handler;

public class ValueAspectDefinition
implements LinkkiAspectDefinition {
    public static final String MSG_CODE_INVALID_INPUT = "valueAspectDefinition.invalidInput";
    public static final String NAME = "";
    @CheckForNull
    private final Converter<?, ?> fixConverter;

    public ValueAspectDefinition() {
        this.fixConverter = null;
    }

    public ValueAspectDefinition(Converter<?, ?> converter) {
        this.fixConverter = converter;
    }

    public void initModelUpdate(PropertyDispatcher propertyDispatcher, ComponentWrapper componentWrapper, Handler modelUpdated) {
        HasValue field = (HasValue)componentWrapper.getComponent();
        if (field instanceof HasValueChangeMode) {
            ((HasValueChangeMode)field).setValueChangeMode(ValueChangeMode.ON_CHANGE);
        }
        Converter<Object, Object> converter = this.getConverter(propertyDispatcher, field);
        field.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (event.isFromClient()) {
                Result result = converter.convertToModel(event.getValue(), this.getValueContext(field));
                result.ifOk((SerializableConsumer & Serializable)v -> {
                    propertyDispatcher.push(Aspect.of((String)NAME, (Object)v));
                    componentWrapper.setValidationMessages(new MessageList(new Message[0]));
                });
                modelUpdated.apply();
                result.ifError((SerializableConsumer & Serializable)s -> componentWrapper.setValidationMessages(this.getInvalidInputMessage(event.getValue())));
            }
        });
    }

    protected MessageList getInvalidInputMessage(@CheckForNull Object value) {
        return new MessageList(new Message[]{Message.newWarning((String)MSG_CODE_INVALID_INPUT, (String)String.format(NlsText.getString("ValueAspectDefinition.invalidInput"), value != null ? value.toString() : "null"))});
    }

    private Type getTypeOf(HasValue<?, ?> field) {
        Map typeArguments = TypeUtils.getTypeArguments(field.getClass(), HasValue.class);
        TypeVariable<Class<T>>[] typeVariables = HasValue.class.getTypeParameters();
        return (Type)typeArguments.get(typeVariables[1]);
    }

    private Converter<Object, Object> getConverter(PropertyDispatcher propertyDispatcher, HasValue<?, ?> field) {
        return this.getConverter(this.getTypeOf(field), propertyDispatcher.getValueClass());
    }

    public Handler createUiUpdater(PropertyDispatcher propertyDispatcher, ComponentWrapper componentWrapper) {
        HasValue field = (HasValue)componentWrapper.getComponent();
        Converter<Object, Object> converter = this.getConverter(propertyDispatcher, field);
        return () -> {
            Object value = propertyDispatcher.pull(Aspect.of((String)NAME));
            if (value != null) {
                field.setValue(converter.convertToPresentation(value, this.getValueContext(field)));
            } else {
                field.clear();
            }
        };
    }

    protected ValueContext getValueContext(HasValue<?, Object> source) {
        return new ValueContext((Component)source, source, UiFramework.getLocale());
    }

    protected Converter<?, ?> getConverter(Type presentationType, Type modelType) {
        if (this.fixConverter != null) {
            return this.fixConverter;
        }
        Converter foundConverter = LinkkiConverterRegistry.getCurrent().findConverter(presentationType, modelType);
        return Optional.ofNullable(foundConverter).orElse(Converter.identity());
    }
}

