/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.aspects.annotation;

import com.vaadin.flow.component.icon.VaadinIcon;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.defaults.ui.aspects.types.IconType;
import org.linkki.core.ui.aspects.IconAspectDefinition;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
@LinkkiAspect(value=BindIconAspectDefinitionCreator.class)
public @interface BindIcon {
    public VaadinIcon value() default VaadinIcon.NATIVE_BUTTON;

    public IconType iconType() default IconType.AUTO;

    public static class BindIconAspectDefinitionCreator
    implements AspectDefinitionCreator<BindIcon> {
        public IconAspectDefinition create(BindIcon bindIcon) {
            return new IconAspectDefinition(bindIcon.iconType(), this.getValueConsiderDefault(bindIcon));
        }

        @CheckForNull
        private VaadinIcon getValueConsiderDefault(BindIcon bindIcon) {
            return bindIcon.iconType() == IconType.AUTO && VaadinIcon.NATIVE_BUTTON.equals((Object)bindIcon.value()) ? null : bindIcon.value();
        }
    }
}

