/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.converters;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.uiframework.UiFramework;

public abstract class FormattedNumberToStringConverter<T extends Number>
implements Converter<String, T> {
    private static final long serialVersionUID = -872944068146887949L;
    private final String format;
    private final Map<Locale, NumberFormat> formats = new HashMap<Locale, NumberFormat>();

    public FormattedNumberToStringConverter(String format) {
        this.format = Objects.requireNonNull(format, "format must not be null");
    }

    public Result<T> convertToModel(@CheckForNull String value, ValueContext context) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Result.ok(this.getNullValue());
        }
        try {
            return Result.ok(this.convertToModel(this.getNumberFormat(this.getLocale(context)).parse(value)));
        }
        catch (ParseException e) {
            return Result.error((String)("Cannot parse '" + value + "' to format '" + this.format + "')"));
        }
    }

    @CheckForNull
    protected abstract T getNullValue();

    protected abstract T convertToModel(Number var1);

    public String convertToPresentation(@CheckForNull T value, ValueContext context) {
        if (value == null) {
            return this.getEmptyPresentation(context);
        }
        return this.getNumberFormat(this.getLocale(context)).format(value);
    }

    protected String getEmptyPresentation(ValueContext context) {
        return context.getHasValue().map(HasValue::getEmptyValue).map(Object::toString).orElse("");
    }

    private NumberFormat getNumberFormat(Locale locale) {
        return this.formats.computeIfAbsent(locale, l -> {
            if (StringUtils.isEmpty((CharSequence)this.format)) {
                return NumberFormat.getIntegerInstance(l);
            }
            return new DecimalFormat(this.format, DecimalFormatSymbols.getInstance(l));
        });
    }

    private Locale getLocale(ValueContext context) {
        return context.getLocale().orElse(UiFramework.getLocale());
    }
}

