/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.creation.section;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.NativeLabel;
import java.lang.reflect.Method;
import java.util.Optional;
import org.linkki.core.binding.BindingContext;
import org.linkki.core.binding.wrapper.WrapperType;
import org.linkki.core.defaults.columnbased.pmo.ContainerPmo;
import org.linkki.core.pmo.ButtonPmo;
import org.linkki.core.pmo.PresentationModelObject;
import org.linkki.core.ui.creation.section.ButtonPmoBinder;
import org.linkki.core.ui.creation.table.GridComponentCreator;
import org.linkki.core.ui.layout.annotation.SectionHeader;
import org.linkki.core.ui.wrapper.FormItemComponentWrapper;
import org.linkki.core.ui.wrapper.LabelComponentWrapper;
import org.linkki.core.ui.wrapper.NoLabelComponentWrapper;
import org.linkki.core.ui.wrapper.VaadinComponentWrapper;
import org.linkki.core.uicreation.ComponentAnnotationReader;
import org.linkki.core.uicreation.UiCreator;
import org.linkki.core.uicreation.layout.LinkkiLayoutDefinition;
import org.linkki.core.vaadin.component.base.LabelComponentFormItem;
import org.linkki.core.vaadin.component.section.BaseSection;
import org.linkki.core.vaadin.component.section.GridSection;
import org.linkki.core.vaadin.component.section.LinkkiSection;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SectionLayoutDefinition implements LinkkiLayoutDefinition
{
    DEFAULT{

        @Override
        protected VaadinComponentWrapper createComponentWrapperAndAddComponentToSection(BaseSection section, NativeLabel label, Component component) {
            LabelComponentFormItem formItem = new LabelComponentFormItem(component, label);
            FormItemComponentWrapper wrapper = new FormItemComponentWrapper(formItem);
            section.addContent((Component)formItem);
            return wrapper;
        }
    }
    ,
    LABEL_ON_TOP{

        @Override
        protected VaadinComponentWrapper createComponentWrapperAndAddComponentToSection(BaseSection section, NativeLabel label, Component component) {
            LabelComponentWrapper componentWrapper = new LabelComponentWrapper(component, WrapperType.FIELD);
            section.addContent(componentWrapper.getComponent());
            return componentWrapper;
        }
    };


    public void createChildren(Object parentComponent, Object pmo, BindingContext bindingContext) {
        this.createHeaderContent((LinkkiSection)parentComponent, pmo, bindingContext);
        if (pmo instanceof ContainerPmo) {
            this.createTable(parentComponent, pmo, bindingContext);
        } else {
            this.createSectionContent(parentComponent, pmo, bindingContext);
        }
    }

    private void createHeaderContent(LinkkiSection section, Object pmo, BindingContext bindingContext) {
        ComponentAnnotationReader.getComponentDefinitionMethods(pmo.getClass()).filter(method -> method.isAnnotationPresent(SectionHeader.class)).forEach(method -> this.addHeaderComponent((Method)method, section, pmo, bindingContext));
        this.getHeaderButtonPmo(pmo).map(b -> ButtonPmoBinder.createBoundButton(bindingContext, b)).ifPresent(section::addHeaderButton);
    }

    private Optional<ButtonPmo> getHeaderButtonPmo(Object pmo) {
        if (pmo instanceof PresentationModelObject) {
            return ((PresentationModelObject)pmo).getEditButtonPmo();
        }
        if (pmo instanceof ContainerPmo) {
            return ((ContainerPmo)pmo).getAddItemButtonPmo();
        }
        return Optional.empty();
    }

    private void addHeaderComponent(Method method, LinkkiSection section, Object pmo, BindingContext bindingContext) {
        NoLabelComponentWrapper wrapper = (NoLabelComponentWrapper)UiCreator.createUiElement((Method)method, (Object)pmo, (BindingContext)bindingContext, c -> new NoLabelComponentWrapper((Component)c, WrapperType.COMPONENT));
        section.addHeaderComponent(wrapper.getComponent());
    }

    private void createSectionContent(Object parentComponent, Object pmo, BindingContext bindingContext) {
        BaseSection section = (BaseSection)parentComponent;
        ComponentAnnotationReader.getComponentDefinitionMethods(pmo.getClass()).filter(method -> !method.isAnnotationPresent(SectionHeader.class)).forEach(method -> this.addSectionComponent((Method)method, section, pmo, bindingContext));
    }

    void addSectionComponent(Method method, BaseSection section, Object pmo, BindingContext bindingContext) {
        UiCreator.createUiElement((Method)method, (Object)pmo, (BindingContext)bindingContext, c -> this.createComponentWrapperAndAddComponentToSection(section, new NativeLabel(), (Component)c));
    }

    protected abstract VaadinComponentWrapper createComponentWrapperAndAddComponentToSection(BaseSection var1, NativeLabel var2, Component var3);

    private void createTable(Object parentComponent, Object pmo, BindingContext bindingContext) {
        GridSection section = (GridSection)parentComponent;
        Grid grid = GridComponentCreator.createGrid((ContainerPmo)pmo, bindingContext);
        section.setGrid(grid);
    }
}

