/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.creation.table;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import java.util.Optional;
import org.linkki.core.defaults.columnbased.ColumnBasedComponentWrapper;
import org.linkki.core.defaults.columnbased.pmo.TableFooterPmo;
import org.linkki.core.ui.wrapper.VaadinComponentWrapper;

public abstract class AbstractGridComponentWrapper<ROW>
extends VaadinComponentWrapper
implements ColumnBasedComponentWrapper<ROW> {
    private static final long serialVersionUID = 1L;

    public AbstractGridComponentWrapper(Grid<ROW> grid) {
        super((Component)grid, COLUMN_BASED_TYPE);
    }

    public Grid<ROW> getComponent() {
        return (Grid)super.getComponent();
    }

    public void setLabel(String labelText) {
    }

    public void updateFooter(Optional<TableFooterPmo> footerPmo) {
        Grid<ROW> grid = this.getComponent();
        if (footerPmo.isPresent()) {
            for (Grid.Column column : grid.getColumns()) {
                column.setFooter(footerPmo.get().getFooterText(column.getKey()));
            }
        }
    }

    public void setPageLength(int pageLength) {
        if (pageLength < 1) {
            if (!this.getComponent().isAllRowsVisible()) {
                this.getComponent().setAllRowsVisible(true);
            }
        } else {
            if (this.getComponent().isAllRowsVisible()) {
                this.getComponent().setAllRowsVisible(false);
            }
            if (this.getComponent().getPageSize() != pageLength) {
                this.getComponent().setPageSize(pageLength);
            }
            int headerAndFooter = 1 + this.getComponent().getFooterRows().size();
            this.getComponent().setHeight((pageLength + headerAndFooter) * 3 + 1 + "em");
        }
    }
}

