/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.creation.table;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.grid.Grid;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.binding.wrapper.WrapperType;
import org.linkki.core.ui.table.column.annotation.UITableColumn;
import org.linkki.core.ui.wrapper.VaadinComponentWrapper;

public class GridColumnWrapper
extends VaadinComponentWrapper {
    public static final WrapperType COLUMN_TYPE = WrapperType.of((String)"column-header");
    public static final String KEY_HEADER = "header";
    private static final long serialVersionUID = 1L;
    private int flexGrow = -1;

    public GridColumnWrapper(Grid.Column<?> column) {
        super((Component)column, COLUMN_TYPE);
    }

    public Grid.Column<?> getComponent() {
        return (Grid.Column)super.getComponent();
    }

    public void setLabel(String labelText) {
        if (!StringUtils.isEmpty((CharSequence)labelText)) {
            this.getComponent().setHeader(labelText);
            ComponentUtil.setData(this.getComponent(), (String)KEY_HEADER, (Object)labelText);
        }
    }

    public void setCollapseMode(UITableColumn.CollapseMode collapseMode) {
        ComponentUtil.setData(this.getComponent(), UITableColumn.CollapseMode.class, (Object)((Object)collapseMode));
        this.getComponent().setVisible(!collapseMode.isInitiallyCollapsed());
    }

    public void setWidth(int width) {
        if (width != -1) {
            this.getComponent().setWidth(width + "px");
            if (this.flexGrow == -1) {
                this.getComponent().setFlexGrow(0);
            }
        }
    }

    public void setFlexGrow(int flexGrow) {
        this.flexGrow = flexGrow;
        if (flexGrow != -1) {
            this.getComponent().setFlexGrow(flexGrow);
        } else {
            this.getComponent().setFlexGrow(0);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.getComponent().getGrid().getId() + "#" + this.getComponent().getId() + "]";
    }
}

