/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.creation.table;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.provider.ListDataProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.linkki.core.defaults.columnbased.pmo.TableFooterPmo;
import org.linkki.core.ui.creation.table.AbstractGridComponentWrapper;

public class GridComponentWrapper<ROW>
extends AbstractGridComponentWrapper<ROW> {
    private static final long serialVersionUID = 1L;
    private final List<ROW> items = new ArrayList<ROW>();

    public GridComponentWrapper(Grid<ROW> grid) {
        super(grid);
        grid.setItems(new ListDataProvider(this.items));
    }

    @Override
    public void setLabel(String labelText) {
    }

    @Override
    public void updateFooter(Optional<TableFooterPmo> footerPmo) {
        Grid grid = this.getComponent();
        if (footerPmo.isPresent()) {
            for (Grid.Column column : grid.getColumns()) {
                column.setFooter(footerPmo.get().getFooterText(column.getKey()));
            }
        }
    }

    public void setItems(List<ROW> newItems) {
        if (this.hasItemListChanged(newItems)) {
            this.items.clear();
            this.items.addAll(newItems);
            this.getComponent().getDataProvider().refreshAll();
            this.getComponent().getElement().setAttribute("has-items", !newItems.isEmpty());
        }
    }

    private boolean hasItemListChanged(List<ROW> newItems) {
        return !this.items.equals(newItems);
    }
}

