/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.creation.table;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.treegrid.TreeGrid;
import java.lang.reflect.Method;
import org.linkki.core.binding.BindingContext;
import org.linkki.core.binding.descriptor.BindingDescriptor;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.defaults.columnbased.pmo.ContainerPmo;
import org.linkki.core.ui.creation.table.ComponentColumnProvider;
import org.linkki.core.ui.creation.table.GridColumnWrapper;
import org.linkki.core.uicreation.ComponentAnnotationReader;
import org.linkki.core.uicreation.layout.LinkkiLayoutDefinition;

public class GridLayoutDefinition
implements LinkkiLayoutDefinition {
    public void createChildren(Object parentComponent, Object pmo, BindingContext bindingContext) {
        this.createColumns((ContainerPmo)pmo, (Grid)parentComponent, bindingContext);
        bindingContext.uiUpdated();
    }

    private void createColumns(ContainerPmo<?> containerPmo, Grid<?> grid, BindingContext bindingContext) {
        Class rowPmoClass = containerPmo.getItemPmoClass();
        ComponentAnnotationReader.getComponentDefinitionMethods((Class)rowPmoClass).forEach(m -> this.initColumn(containerPmo, grid, bindingContext, (Method)m));
    }

    private void initColumn(ContainerPmo<?> containerPmo, Grid<?> grid, BindingContext bindingContext, Method m) {
        BindingDescriptor bindingDescriptor = BindingDescriptor.forMethod((Method)m);
        Grid.Column<?> column = this.createComponentColumn(m, grid, bindingContext);
        column.setKey(bindingDescriptor.getBoundProperty().getPmoProperty());
        column.setResizable(true);
        bindingContext.bind((Object)containerPmo.getItemPmoClass(), bindingDescriptor, (ComponentWrapper)new GridColumnWrapper(column));
    }

    private <ROW> Grid.Column<ROW> createComponentColumn(Method m, Grid<ROW> grid, BindingContext bindingContext) {
        ComponentColumnProvider columnGen = new ComponentColumnProvider(m, bindingContext);
        if (grid instanceof TreeGrid && grid.getColumns().size() == 0) {
            return ((TreeGrid)grid).addComponentHierarchyColumn(columnGen);
        }
        return grid.addComponentColumn(columnGen);
    }
}

