/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.creation.table;

import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import java.util.Collections;
import java.util.List;
import org.linkki.core.defaults.columnbased.pmo.HierarchicalRowPmo;
import org.linkki.core.ui.creation.table.AbstractGridComponentWrapper;

public class TreeGridComponentWrapper<ROW>
extends AbstractGridComponentWrapper<ROW> {
    private static final long serialVersionUID = 1L;
    private final TreeData<ROW> treeData = new TreeData();

    public TreeGridComponentWrapper(TreeGrid<ROW> grid) {
        super(grid);
        grid.setDataProvider((HierarchicalDataProvider)new TreeDataProvider(this.treeData));
    }

    @Override
    public TreeGrid<ROW> getComponent() {
        return (TreeGrid)super.getComponent();
    }

    public void setItems(List<ROW> rootItems) {
        if (this.hasItemListChanged(rootItems) || this.hasChildChanged((ROW)rootItems)) {
            this.treeData.clear();
            this.treeData.addItems(rootItems, this::getCurrentChildren);
            this.getComponent().getDataProvider().refreshAll();
            this.getComponent().getElement().setAttribute("has-items", !rootItems.isEmpty());
        }
    }

    private boolean hasItemListChanged(List<ROW> rootItems) {
        return !this.treeData.getRootItems().equals(rootItems);
    }

    private boolean hasChildChanged(List<? extends ROW> newItems) {
        return newItems.stream().anyMatch(this::hasChildChanged);
    }

    private boolean hasChildChanged(ROW item) {
        if (!this.treeData.contains(item)) {
            return false;
        }
        List storedChildren = this.treeData.getChildren(item);
        List<ROW> currentChildren = this.getCurrentChildren(item);
        return !currentChildren.equals(storedChildren) || this.hasChildChanged((ROW)currentChildren);
    }

    private List<ROW> getCurrentChildren(ROW item) {
        if (item instanceof HierarchicalRowPmo) {
            HierarchicalRowPmo hierarchicalRowPmo = (HierarchicalRowPmo)item;
            return hierarchicalRowPmo.getChildRows();
        }
        return Collections.emptyList();
    }
}

