/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.element.annotation;

import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.ComboBoxBase;
import com.vaadin.flow.component.combobox.ComboBoxVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.base.StaticModelToUiAspectDefinition;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.binding.validation.message.Message;
import org.linkki.core.binding.validation.message.MessageList;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.defaults.ui.aspects.EnabledAspectDefinition;
import org.linkki.core.defaults.ui.aspects.VisibleAspectDefinition;
import org.linkki.core.defaults.ui.aspects.types.AvailableValuesType;
import org.linkki.core.defaults.ui.aspects.types.EnabledType;
import org.linkki.core.defaults.ui.aspects.types.RequiredType;
import org.linkki.core.defaults.ui.aspects.types.VisibleType;
import org.linkki.core.defaults.ui.element.ItemCaptionProvider;
import org.linkki.core.ui.aspects.AvailableValuesAspectDefinition;
import org.linkki.core.ui.aspects.BindComboBoxItemStyleAspectDefinition;
import org.linkki.core.ui.aspects.DerivedReadOnlyAspectDefinition;
import org.linkki.core.ui.aspects.LabelAspectDefinition;
import org.linkki.core.ui.aspects.RequiredAspectDefinition;
import org.linkki.core.ui.aspects.ValueAspectDefinition;
import org.linkki.core.ui.aspects.types.TextAlignment;
import org.linkki.core.uicreation.ComponentDefinitionCreator;
import org.linkki.core.uicreation.LinkkiPositioned;
import org.linkki.core.vaadin.component.ComponentFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@LinkkiBoundProperty
@LinkkiComponent(value=ComboBoxComponentDefinitionCreator.class)
@LinkkiAspect(value=ComboBoxAspectCreator.class)
@LinkkiPositioned
public @interface UIComboBox {
    @LinkkiPositioned.Position
    public int position();

    public String label() default "derived.by.linkki";

    public AvailableValuesType content() default AvailableValuesType.ENUM_VALUES_INCL_NULL;

    public EnabledType enabled() default EnabledType.ENABLED;

    public RequiredType required() default RequiredType.NOT_REQUIRED;

    public VisibleType visible() default VisibleType.VISIBLE;

    public String width() default "-1px";

    @LinkkiBoundProperty.ModelObjectProperty
    public String modelObject() default "modelObject";

    @LinkkiBoundProperty.ModelAttribute
    public String modelAttribute() default "";

    public Class<? extends ItemCaptionProvider<?>> itemCaptionProvider() default ItemCaptionProvider.DefaultCaptionProvider.class;

    public TextAlignment textAlign() default TextAlignment.DEFAULT;

    public static class ComboBoxComponentDefinitionCreator
    implements ComponentDefinitionCreator<UIComboBox> {
        public LinkkiComponentDefinition create(UIComboBox annotation, AnnotatedElement annotatedElement) {
            return pmo -> {
                ComboBox comboBox = ComponentFactory.newComboBox();
                comboBox.setItemLabelGenerator(arg_0 -> ((ItemCaptionProvider)ItemCaptionProvider.instantiate(annotation::itemCaptionProvider)).getUnsafeCaption(arg_0));
                comboBox.setWidth(annotation.width());
                return comboBox;
            };
        }
    }

    public static class ComboBoxAspectCreator
    implements AspectDefinitionCreator<UIComboBox> {
        public LinkkiAspectDefinition create(UIComboBox annotation) {
            ComboBoxAvailableValuesAspectDefinition availableValuesAspectDefinition = new ComboBoxAvailableValuesAspectDefinition(annotation.content(), ComboBoxBase::setItems, annotation);
            EnabledAspectDefinition enabledAspectDefinition = new EnabledAspectDefinition(annotation.enabled());
            RequiredAspectDefinition requiredAspectDefinition = new RequiredAspectDefinition(annotation.required(), enabledAspectDefinition);
            return new CompositeAspectDefinition(new LinkkiAspectDefinition[]{new LabelAspectDefinition(annotation.label()), enabledAspectDefinition, requiredAspectDefinition, availableValuesAspectDefinition, new VisibleAspectDefinition(annotation.visible()), new ComboBoxValueAspectDefinition(), new DerivedReadOnlyAspectDefinition(), new TextAlignAspectDefinition(annotation.textAlign())});
        }

        private static final class ComboBoxAvailableValuesAspectDefinition
        extends AvailableValuesAspectDefinition<ComboBox<Object>> {
            private final UIComboBox annotation;

            private ComboBoxAvailableValuesAspectDefinition(AvailableValuesType availableValuesType, BiConsumer<ComboBox<Object>, List<Object>> dataProviderSetter, UIComboBox annotation) {
                super(availableValuesType, dataProviderSetter);
                this.annotation = annotation;
            }

            @Override
            protected void handleNullItems(ComponentWrapper componentWrapper, List<?> items) {
                boolean dynamicItemsEmpty = this.annotation.content() == AvailableValuesType.DYNAMIC && items.isEmpty();
                boolean hasNullItem = items.removeIf(Objects::isNull);
                ((ComboBox)componentWrapper.getComponent()).setClearButtonVisible(hasNullItem || dynamicItemsEmpty);
            }
        }

        private static final class ComboBoxValueAspectDefinition
        extends ValueAspectDefinition {
            private ComboBoxValueAspectDefinition() {
            }

            @Override
            protected Converter<?, ?> getConverter(Type presentationType, Type modelType) {
                return new ComboBoxValueConverter(super.getConverter(presentationType, modelType));
            }

            @Override
            protected MessageList getInvalidInputMessage(Object value) {
                return new MessageList(new Message[0]);
            }
        }

        private static final class TextAlignAspectDefinition
        extends StaticModelToUiAspectDefinition<TextAlignment> {
            public static final String NAME = "textAlignment";
            private final TextAlignment textAlignment;

            public TextAlignAspectDefinition(TextAlignment textAlignment) {
                this.textAlignment = textAlignment;
            }

            public Aspect<TextAlignment> createAspect() {
                return Aspect.of((String)NAME, (Object)((Object)this.textAlignment));
            }

            public Consumer<TextAlignment> createComponentValueSetter(ComponentWrapper componentWrapper) {
                return ta -> this.setTextAlign(componentWrapper, (TextAlignment)((Object)ta));
            }

            private void setTextAlign(ComponentWrapper componentWrapper, TextAlignment alignment) {
                if (alignment != TextAlignment.DEFAULT) {
                    String style = this.getStyle(alignment);
                    new BindComboBoxItemStyleAspectDefinition(this.getStyle(alignment)).createComponentValueSetter(componentWrapper).accept($ -> style);
                    ComboBox comboBox = (ComboBox)componentWrapper.getComponent();
                    comboBox.addThemeVariants((ThemeVariant[])new ComboBoxVariant[]{this.getVariant(alignment)});
                }
            }

            private ComboBoxVariant getVariant(TextAlignment alignment) {
                switch (alignment) {
                    case LEFT: {
                        return ComboBoxVariant.LUMO_ALIGN_LEFT;
                    }
                    case CENTER: {
                        return ComboBoxVariant.LUMO_ALIGN_CENTER;
                    }
                    case RIGHT: {
                        return ComboBoxVariant.LUMO_ALIGN_RIGHT;
                    }
                }
                throw new IllegalArgumentException("Invalid text alignment: " + alignment.name());
            }

            private String getStyle(TextAlignment alignment) {
                switch (alignment) {
                    case LEFT: {
                        return "text-left";
                    }
                    case CENTER: {
                        return "text-center";
                    }
                    case RIGHT: {
                        return "text-right";
                    }
                }
                throw new IllegalArgumentException("Invalid text alignment: " + alignment.name());
            }
        }

        private static final class ComboBoxValueConverter
        implements Converter<Object, Object> {
            private static final long serialVersionUID = -7386708403118050830L;
            private final Converter<Object, Object> wrappedConverter;

            public ComboBoxValueConverter(Converter<?, ?> wrappedConverter) {
                this.wrappedConverter = wrappedConverter;
            }

            public Result<Object> convertToModel(Object value, ValueContext context) {
                if (value == null) {
                    if (context.getComponent().map(ComboBox.class::cast).map(cb -> !cb.isClearButtonVisible()).orElse(false).booleanValue()) {
                        return Result.error((String)"Null is not an available value");
                    }
                }
                return this.wrappedConverter.convertToModel(value, context);
            }

            public Object convertToPresentation(Object value, ValueContext context) {
                String converted;
                Optional component = context.getComponent();
                if (component.isPresent() && StringUtils.isNotEmpty((CharSequence)(converted = ((ComboBox)component.get()).getItemLabelGenerator().apply(value)))) {
                    return this.wrappedConverter.convertToPresentation(value, context);
                }
                return null;
            }
        }
    }
}

