/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.element.annotation;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.data.provider.HasListDataView;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import org.linkki.core.binding.LinkkiBindingException;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.aspect.base.ApplicableTypeAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.defaults.ui.aspects.EnabledAspectDefinition;
import org.linkki.core.defaults.ui.aspects.VisibleAspectDefinition;
import org.linkki.core.defaults.ui.aspects.types.AvailableValuesType;
import org.linkki.core.defaults.ui.aspects.types.EnabledType;
import org.linkki.core.defaults.ui.aspects.types.RequiredType;
import org.linkki.core.defaults.ui.aspects.types.VisibleType;
import org.linkki.core.ui.aspects.DerivedReadOnlyAspectDefinition;
import org.linkki.core.ui.aspects.GenericAvailableValuesAspectDefinition;
import org.linkki.core.ui.aspects.LabelAspectDefinition;
import org.linkki.core.ui.aspects.RequiredAspectDefinition;
import org.linkki.core.ui.aspects.ValueAspectDefinition;
import org.linkki.core.uicreation.ComponentDefinitionCreator;
import org.linkki.core.uicreation.LinkkiPositioned;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@LinkkiBoundProperty
@LinkkiComponent(value=CustomFieldComponentDefinitionCreator.class)
@LinkkiAspect(value=CustomFieldAspectCreator.class)
@LinkkiPositioned
public @interface UICustomField {
    @LinkkiPositioned.Position
    public int position();

    public String label() default "derived.by.linkki";

    @LinkkiBoundProperty.ModelObjectProperty
    public String modelObject() default "modelObject";

    @LinkkiBoundProperty.ModelAttribute
    public String modelAttribute() default "";

    public EnabledType enabled() default EnabledType.ENABLED;

    public RequiredType required() default RequiredType.NOT_REQUIRED;

    public VisibleType visible() default VisibleType.VISIBLE;

    public String width() default "";

    public AvailableValuesType content() default AvailableValuesType.ENUM_VALUES_INCL_NULL;

    public Class<? extends Component> uiControl();

    public static class CustomFieldComponentDefinitionCreator
    implements ComponentDefinitionCreator<UICustomField> {
        public LinkkiComponentDefinition create(UICustomField annotation, AnnotatedElement annotatedElement) {
            return pmo -> {
                try {
                    Component component = annotation.uiControl().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (component instanceof HasSize) {
                        ((HasSize)component).setWidth(annotation.width());
                    }
                    return component;
                }
                catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                    throw new LinkkiBindingException("Cannot instantiate component " + annotation.uiControl().getName() + " using default constructor.", e);
                }
            };
        }
    }

    public static class CustomFieldAspectCreator
    implements AspectDefinitionCreator<UICustomField> {
        public LinkkiAspectDefinition create(UICustomField annotation) {
            ApplicableTypeAspectDefinition availableValuesAspectDefinition = ApplicableTypeAspectDefinition.ifComponentTypeIs(HasListDataView.class, (LinkkiAspectDefinition)new GenericAvailableValuesAspectDefinition(annotation.content()));
            EnabledAspectDefinition enabledAspectDefinition = new EnabledAspectDefinition(annotation.enabled());
            RequiredAspectDefinition requiredAspectDefinition = new RequiredAspectDefinition(annotation.required(), enabledAspectDefinition);
            return new CompositeAspectDefinition(new LinkkiAspectDefinition[]{new LabelAspectDefinition(annotation.label()), enabledAspectDefinition, requiredAspectDefinition, availableValuesAspectDefinition, new VisibleAspectDefinition(annotation.visible()), new ValueAspectDefinition(), new DerivedReadOnlyAspectDefinition()});
        }
    }
}

