/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.element.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.defaults.ui.aspects.EnabledAspectDefinition;
import org.linkki.core.defaults.ui.aspects.VisibleAspectDefinition;
import org.linkki.core.defaults.ui.aspects.types.EnabledType;
import org.linkki.core.defaults.ui.aspects.types.RequiredType;
import org.linkki.core.defaults.ui.aspects.types.VisibleType;
import org.linkki.core.ui.aspects.DerivedReadOnlyAspectDefinition;
import org.linkki.core.ui.aspects.LabelAspectDefinition;
import org.linkki.core.ui.aspects.PrimitiveAwareValueAspectDefinition;
import org.linkki.core.ui.aspects.RequiredAspectDefinition;
import org.linkki.core.ui.converters.FormattedDoubleToStringConverter;
import org.linkki.core.uicreation.ComponentDefinitionCreator;
import org.linkki.core.uicreation.LinkkiPositioned;
import org.linkki.core.vaadin.component.ComponentFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@LinkkiBoundProperty
@LinkkiComponent(value=DoubleFieldComponentDefinitionCreator.class)
@LinkkiAspect(value=DoubleFieldAspectCreator.class)
@LinkkiPositioned
public @interface UIDoubleField {
    @LinkkiPositioned.Position
    public int position();

    public String label() default "derived.by.linkki";

    public EnabledType enabled() default EnabledType.ENABLED;

    public RequiredType required() default RequiredType.NOT_REQUIRED;

    public VisibleType visible() default VisibleType.VISIBLE;

    public int maxLength() default 0;

    public String width() default "";

    public String format() default "#,##0.00##";

    @LinkkiBoundProperty.ModelObjectProperty
    public String modelObject() default "modelObject";

    @LinkkiBoundProperty.ModelAttribute
    public String modelAttribute() default "";

    public static class DoubleFieldComponentDefinitionCreator
    implements ComponentDefinitionCreator<UIDoubleField> {
        public LinkkiComponentDefinition create(UIDoubleField annotation, AnnotatedElement annotatedElement) {
            return pmo -> ComponentFactory.newNumberField(annotation.maxLength(), annotation.width(), "[-+,\\.\\d]");
        }
    }

    public static class DoubleFieldAspectCreator
    implements AspectDefinitionCreator<UIDoubleField> {
        public LinkkiAspectDefinition create(UIDoubleField annotation) {
            EnabledAspectDefinition enabledAspectDefinition = new EnabledAspectDefinition(annotation.enabled());
            RequiredAspectDefinition requiredAspectDefinition = new RequiredAspectDefinition(annotation.required(), enabledAspectDefinition);
            return new CompositeAspectDefinition(new LinkkiAspectDefinition[]{new LabelAspectDefinition(annotation.label()), enabledAspectDefinition, requiredAspectDefinition, new VisibleAspectDefinition(annotation.visible()), new PrimitiveAwareValueAspectDefinition(new FormattedDoubleToStringConverter(annotation.format())), new DerivedReadOnlyAspectDefinition()});
        }
    }
}

