/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.element.annotation;

import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.defaults.ui.aspects.VisibleAspectDefinition;
import org.linkki.core.defaults.ui.aspects.types.VisibleType;
import org.linkki.core.defaults.ui.element.ItemCaptionProvider;
import org.linkki.core.ui.aspects.IconPositionAspectDefinition;
import org.linkki.core.ui.aspects.LabelAspectDefinition;
import org.linkki.core.ui.aspects.LabelValueAspectDefinition;
import org.linkki.core.ui.aspects.types.IconPosition;
import org.linkki.core.ui.converters.LinkkiConverterRegistry;
import org.linkki.core.uicreation.ComponentDefinitionCreator;
import org.linkki.core.uicreation.LinkkiPositioned;
import org.linkki.core.uiframework.UiFramework;
import org.linkki.core.vaadin.component.base.LinkkiText;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@LinkkiBoundProperty
@LinkkiComponent(value=LabelComponentDefinitionCreator.class)
@LinkkiAspect(value=LabelAspectDefinitionCreator.class)
@LinkkiPositioned
public @interface UILabel {
    @LinkkiPositioned.Position
    public int position();

    public String label() default "";

    public VisibleType visible() default VisibleType.VISIBLE;

    public IconPosition iconPosition() default IconPosition.LEFT;

    @LinkkiBoundProperty.ModelObjectProperty
    public String modelObject() default "modelObject";

    @LinkkiBoundProperty.ModelAttribute
    public String modelAttribute() default "";

    public String[] styleNames() default {};

    @Deprecated(since="2.5.0")
    public boolean htmlContent() default false;

    public Class<? extends ItemCaptionProvider<?>> itemCaptionProvider() default DefaultLabelCaptionProvider.class;

    public static class LabelComponentDefinitionCreator
    implements ComponentDefinitionCreator<UILabel> {
        public LinkkiComponentDefinition create(UILabel annotation, AnnotatedElement annotatedElement) {
            return pmo -> {
                LinkkiText label = new LinkkiText();
                for (String styleName : annotation.styleNames()) {
                    label.addClassName(styleName);
                }
                return label;
            };
        }
    }

    public static class LabelAspectDefinitionCreator
    implements AspectDefinitionCreator<UILabel> {
        public LinkkiAspectDefinition create(UILabel annotation) {
            LinkkiAspectDefinition[] linkkiAspectDefinitionArray = new LinkkiAspectDefinition[4];
            linkkiAspectDefinitionArray[0] = new LabelAspectDefinition(annotation.label());
            linkkiAspectDefinitionArray[1] = new VisibleAspectDefinition(annotation.visible());
            linkkiAspectDefinitionArray[2] = new LabelValueAspectDefinition(annotation.htmlContent(), ItemCaptionProvider.instantiate(annotation::itemCaptionProvider));
            linkkiAspectDefinitionArray[3] = new IconPositionAspectDefinition(annotation.iconPosition());
            return new CompositeAspectDefinition(linkkiAspectDefinitionArray);
        }
    }

    public static class DefaultLabelCaptionProvider
    implements ItemCaptionProvider<Object> {
        public String getCaption(Object o) {
            if (o != null) {
                try {
                    Converter converter = LinkkiConverterRegistry.getCurrent().findConverter((Type)((Object)String.class), o.getClass());
                    return (String)converter.convertToPresentation(o, new ValueContext(UiFramework.getLocale()));
                }
                catch (IllegalArgumentException e) {
                    return new ItemCaptionProvider.DefaultCaptionProvider().getCaption(o);
                }
            }
            return "";
        }
    }
}

