/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.element.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.binding.descriptor.property.annotation.BoundPropertyCreator;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.defaults.ui.aspects.VisibleAspectDefinition;
import org.linkki.core.defaults.ui.aspects.types.CaptionType;
import org.linkki.core.defaults.ui.aspects.types.VisibleType;
import org.linkki.core.ui.aspects.CaptionAspectDefinition;
import org.linkki.core.ui.aspects.IconPositionAspectDefinition;
import org.linkki.core.ui.aspects.LabelAspectDefinition;
import org.linkki.core.ui.aspects.LinkHrefAspectDefinition;
import org.linkki.core.ui.aspects.LinkTargetAspectDefinition;
import org.linkki.core.ui.aspects.types.IconPosition;
import org.linkki.core.uicreation.ComponentDefinitionCreator;
import org.linkki.core.uicreation.LinkkiPositioned;
import org.linkki.core.vaadin.component.ComponentFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@LinkkiBoundProperty(value=BoundPropertyCreator.SimpleMemberNameBoundPropertyCreator.class)
@LinkkiComponent(value=LinkComponentDefinitionCreator.class)
@LinkkiAspect(value=LinkAspectDefinitionCreator.class)
@LinkkiPositioned
public @interface UILink {
    @LinkkiPositioned.Position
    public int position();

    public String label() default "";

    public VisibleType visible() default VisibleType.VISIBLE;

    public String caption() default "";

    public CaptionType captionType() default CaptionType.AUTO;

    public String target() default "_self";

    public IconPosition iconPosition() default IconPosition.RIGHT;

    public static final class LinkTarget {
        public static final String DYNAMIC = "";
        public static final String BLANK = "_blank";
        public static final String SELF = "_self";
        public static final String PARENT = "_parent";
        public static final String TOP = "_top";

        private LinkTarget() {
        }
    }

    public static class LinkAspectDefinitionCreator
    implements AspectDefinitionCreator<UILink> {
        public LinkkiAspectDefinition create(UILink annotation) {
            return new CompositeAspectDefinition(new LinkkiAspectDefinition[]{new LabelAspectDefinition(annotation.label()), new VisibleAspectDefinition(annotation.visible()), new LinkHrefAspectDefinition(), new CaptionAspectDefinition(annotation.captionType(), annotation.caption()), new LinkTargetAspectDefinition(annotation.target(), "".equals(annotation.target())), new IconPositionAspectDefinition(annotation.iconPosition())});
        }
    }

    public static class LinkComponentDefinitionCreator
    implements ComponentDefinitionCreator<UILink> {
        public LinkkiComponentDefinition create(UILink annotation, AnnotatedElement annotatedElement) {
            return pmo -> ComponentFactory.newLink(annotation.caption());
        }
    }
}

