/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.element.annotation;

import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.defaults.ui.aspects.EnabledAspectDefinition;
import org.linkki.core.defaults.ui.aspects.VisibleAspectDefinition;
import org.linkki.core.defaults.ui.aspects.types.AlignmentType;
import org.linkki.core.defaults.ui.aspects.types.AvailableValuesType;
import org.linkki.core.defaults.ui.aspects.types.EnabledType;
import org.linkki.core.defaults.ui.aspects.types.RequiredType;
import org.linkki.core.defaults.ui.aspects.types.VisibleType;
import org.linkki.core.defaults.ui.element.ItemCaptionProvider;
import org.linkki.core.ui.aspects.DerivedReadOnlyAspectDefinition;
import org.linkki.core.ui.aspects.GenericAvailableValuesAspectDefinition;
import org.linkki.core.ui.aspects.LabelAspectDefinition;
import org.linkki.core.ui.aspects.RequiredAspectDefinition;
import org.linkki.core.ui.aspects.ValueAspectDefinition;
import org.linkki.core.uicreation.ComponentDefinitionCreator;
import org.linkki.core.uicreation.LinkkiPositioned;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@LinkkiPositioned
@LinkkiAspect(value=RadioButtonsAspectDefinitionCreator.class)
@LinkkiBoundProperty
@LinkkiComponent(value=RadioButtonsComponentDefinitionCreator.class)
public @interface UIRadioButtons {
    @LinkkiPositioned.Position
    public int position();

    public String label() default "";

    public AvailableValuesType content() default AvailableValuesType.ENUM_VALUES_EXCL_NULL;

    public EnabledType enabled() default EnabledType.ENABLED;

    public RequiredType required() default RequiredType.NOT_REQUIRED;

    public VisibleType visible() default VisibleType.VISIBLE;

    public Class<? extends ItemCaptionProvider<?>> itemCaptionProvider() default ItemCaptionProvider.DefaultCaptionProvider.class;

    @LinkkiBoundProperty.ModelObjectProperty
    public String modelObject() default "modelObject";

    @LinkkiBoundProperty.ModelAttribute
    public String modelAttribute() default "";

    public AlignmentType buttonAlignment() default AlignmentType.VERTICAL;

    public static class RadioButtonsComponentDefinitionCreator
    implements ComponentDefinitionCreator<UIRadioButtons> {
        public LinkkiComponentDefinition create(UIRadioButtons annotation, AnnotatedElement annotatedElement) {
            return pmo -> {
                RadioButtonGroup radioButtons = new RadioButtonGroup();
                radioButtons.setRenderer((ComponentRenderer)new TextRenderer(arg_0 -> ((ItemCaptionProvider)ItemCaptionProvider.instantiate(annotation::itemCaptionProvider)).getUnsafeCaption(arg_0)));
                AlignmentType alignment = annotation.buttonAlignment();
                if (alignment.equals((Object)AlignmentType.VERTICAL)) {
                    radioButtons.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
                }
                return radioButtons;
            };
        }
    }

    public static class RadioButtonsAspectDefinitionCreator
    implements AspectDefinitionCreator<UIRadioButtons> {
        public LinkkiAspectDefinition create(UIRadioButtons annotation) {
            GenericAvailableValuesAspectDefinition availableValuesAspectDefinition = new GenericAvailableValuesAspectDefinition(annotation.content());
            EnabledAspectDefinition enabledAspectDefinition = new EnabledAspectDefinition(annotation.enabled());
            RequiredAspectDefinition requiredAspectDefinition = new RequiredAspectDefinition(annotation.required(), enabledAspectDefinition);
            return new CompositeAspectDefinition(new LinkkiAspectDefinition[]{new LabelAspectDefinition(annotation.label()), enabledAspectDefinition, requiredAspectDefinition, availableValuesAspectDefinition, new ValueAspectDefinition(), new VisibleAspectDefinition(annotation.visible()), new DerivedReadOnlyAspectDefinition()});
        }
    }
}

