/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.element.annotation;

import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.ComboBoxBase;
import com.vaadin.flow.data.converter.Converter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.binding.validation.message.Message;
import org.linkki.core.binding.validation.message.MessageList;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.defaults.nls.NlsText;
import org.linkki.core.defaults.ui.aspects.EnabledAspectDefinition;
import org.linkki.core.defaults.ui.aspects.VisibleAspectDefinition;
import org.linkki.core.defaults.ui.aspects.types.AvailableValuesType;
import org.linkki.core.defaults.ui.aspects.types.EnabledType;
import org.linkki.core.defaults.ui.aspects.types.RequiredType;
import org.linkki.core.defaults.ui.aspects.types.VisibleType;
import org.linkki.core.defaults.ui.element.ItemCaptionProvider;
import org.linkki.core.ui.aspects.AvailableValuesAspectDefinition;
import org.linkki.core.ui.aspects.DerivedReadOnlyAspectDefinition;
import org.linkki.core.ui.aspects.LabelAspectDefinition;
import org.linkki.core.ui.aspects.RequiredAspectDefinition;
import org.linkki.core.ui.aspects.ValueAspectDefinition;
import org.linkki.core.ui.converters.NullHandlingConverterWrapper;
import org.linkki.core.uicreation.ComponentDefinitionCreator;
import org.linkki.core.uicreation.LinkkiPositioned;
import org.linkki.core.vaadin.component.ComponentFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@LinkkiBoundProperty
@LinkkiComponent(value=YesNoComboBoxComponentDefinitionCreator.class)
@LinkkiAspect(value=YesNoComboBoxAspectCreator.class)
@LinkkiPositioned
public @interface UIYesNoComboBox {
    @LinkkiPositioned.Position
    public int position();

    public String label() default "derived.by.linkki";

    public EnabledType enabled() default EnabledType.ENABLED;

    public RequiredType required() default RequiredType.NOT_REQUIRED;

    public VisibleType visible() default VisibleType.VISIBLE;

    public String width() default "-1px";

    @LinkkiBoundProperty.ModelObjectProperty
    public String modelObject() default "modelObject";

    @LinkkiBoundProperty.ModelAttribute
    public String modelAttribute() default "";

    public Class<? extends ItemCaptionProvider<?>> itemCaptionProvider() default BooleanCaptionProvider.class;

    public static class BooleanCaptionProvider
    implements ItemCaptionProvider<Object> {
        @NonNull
        public String getCaption(Object o) {
            return o instanceof Boolean ? this.booleanToCaption((Boolean)o) : "";
        }

        private String booleanToCaption(Boolean bool) {
            return bool != false ? NlsText.getString((String)"BooleanCaptionProvider.True") : NlsText.getString((String)"BooleanCaptionProvider.False");
        }
    }

    public static class YesNoComboBoxComponentDefinitionCreator
    implements ComponentDefinitionCreator<UIYesNoComboBox> {
        public LinkkiComponentDefinition create(UIYesNoComboBox annotation, AnnotatedElement annotatedElement) {
            return pmo -> {
                ComboBox comboBox = ComponentFactory.newComboBox();
                comboBox.setItemLabelGenerator(arg_0 -> ((ItemCaptionProvider)ItemCaptionProvider.instantiate(annotation::itemCaptionProvider)).getUnsafeCaption(arg_0));
                comboBox.setAllowCustomValue(false);
                comboBox.setWidth(annotation.width());
                return comboBox;
            };
        }
    }

    public static class YesNoComboBoxValueAspectDefinition
    extends ValueAspectDefinition {
        @Override
        protected Converter<?, ?> getConverter(Type presentationType, Type modelType) {
            if (modelType instanceof Class && ((Class)modelType).isPrimitive()) {
                return new NullHandlingConverterWrapper(super.getConverter(presentationType, modelType));
            }
            return super.getConverter(presentationType, modelType);
        }

        @Override
        protected MessageList getInvalidInputMessage(Object value) {
            return new MessageList(new Message[0]);
        }
    }

    public static class YesNoComboBoxAspectCreator
    implements AspectDefinitionCreator<UIYesNoComboBox> {
        public LinkkiAspectDefinition create(UIYesNoComboBox annotation) {
            AvailableValuesAspectDefinition<ComboBox<Object>> availableValuesAspectDefinition = new AvailableValuesAspectDefinition<ComboBox<Object>>(AvailableValuesType.ENUM_VALUES_INCL_NULL, ComboBoxBase::setItems){

                @Override
                protected void handleNullItems(ComponentWrapper componentWrapper, List<?> items) {
                    boolean hasNullItem = items.removeIf(Objects::isNull);
                    ((ComboBox)componentWrapper.getComponent()).setClearButtonVisible(hasNullItem);
                }
            };
            EnabledAspectDefinition enabledAspectDefinition = new EnabledAspectDefinition(annotation.enabled());
            RequiredAspectDefinition requiredAspectDefinition = new RequiredAspectDefinition(annotation.required(), enabledAspectDefinition);
            return new CompositeAspectDefinition(new LinkkiAspectDefinition[]{new LabelAspectDefinition(annotation.label()), enabledAspectDefinition, requiredAspectDefinition, availableValuesAspectDefinition, new VisibleAspectDefinition(annotation.visible()), new YesNoComboBoxValueAspectDefinition(), new DerivedReadOnlyAspectDefinition()});
        }
    }
}

