/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.pmo;

import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.IconFactory;
import com.vaadin.flow.component.icon.VaadinIcon;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.linkki.core.pmo.ButtonPmo;
import org.linkki.util.handler.Handler;

public class ButtonPmoBuilder {
    private final Handler action;
    @CheckForNull
    private Icon icon;

    public ButtonPmoBuilder(Handler onClickAction) {
        this.action = Objects.requireNonNull(onClickAction, "onClickAction must not be null");
    }

    public static ButtonPmo newEditButton(Handler onClickAction) {
        return ButtonPmoBuilder.action(onClickAction).icon((IconFactory)VaadinIcon.PENCIL).get();
    }

    public static ButtonPmo newAddButton(Handler onClickAction) {
        return ButtonPmoBuilder.action(onClickAction).icon((IconFactory)VaadinIcon.PLUS).get();
    }

    public static ButtonPmo newDeleteButton(Handler onClickAction) {
        return ButtonPmoBuilder.action(onClickAction).icon((IconFactory)VaadinIcon.TRASH).get();
    }

    public static ButtonPmoBuilder action(Handler onClickAction) {
        return new ButtonPmoBuilder(onClickAction);
    }

    public ButtonPmoBuilder icon(Icon buttonIcon) {
        this.icon = buttonIcon;
        return this;
    }

    public ButtonPmoBuilder icon(IconFactory buttonIconFactory) {
        this.icon = buttonIconFactory.create();
        return this;
    }

    Handler getAction() {
        return this.action;
    }

    public ButtonPmo get() {
        final Icon existingIcon = Objects.requireNonNull(this.icon, "icon must be set before calling get()");
        return new ButtonPmo(){

            public void onClick() {
                ButtonPmoBuilder.this.getAction().apply();
            }

            public Icon getButtonIcon() {
                return existingIcon;
            }

            public List<String> getStyleNames() {
                return new ArrayList<String>();
            }
        };
    }
}

