/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.table.aspects;

import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.dispatcher.PropertyDispatcher;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.binding.wrapper.WrapperType;
import org.linkki.core.ui.creation.table.GridColumnWrapper;
import org.linkki.util.handler.Handler;
import org.linkki.util.reflection.accessor.PropertyAccessor;

public class ColumnSortableAspectDefinition
implements LinkkiAspectDefinition {
    private final boolean sortable;

    public ColumnSortableAspectDefinition(boolean sortable) {
        this.sortable = sortable;
    }

    public void initModelUpdate(PropertyDispatcher propertyDispatcher, ComponentWrapper componentWrapper, Handler modelChanged) {
        if (this.sortable) {
            this.initComparator(propertyDispatcher, (GridColumnWrapper)componentWrapper);
        }
    }

    private void initComparator(PropertyDispatcher propertyDispatcher, GridColumnWrapper columnWrapper) {
        Class pmoClass = (Class)propertyDispatcher.getBoundObject();
        if (pmoClass == null) {
            throw new IllegalStateException("Could not obtain bound object");
        }
        PropertyAccessor accessor = PropertyAccessor.get((Class)pmoClass, (String)propertyDispatcher.getProperty());
        if (!accessor.canRead()) {
            String message = "Could not read %s#%s. Using a model object is not supported when using sortable in @UITableColumn.";
            throw new IllegalStateException(String.format(message, pmoClass.getSimpleName(), propertyDispatcher.getProperty()));
        }
        Class valueClass = accessor.getValueClass();
        if (!Comparable.class.isAssignableFrom(valueClass)) {
            String message = "Cannot sort by %s#%s as %s does not implement Comparable. This is required when using sortable in @UITableColumn.";
            throw new IllegalStateException(String.format(message, pmoClass.getSimpleName(), propertyDispatcher.getProperty(), valueClass.getCanonicalName()));
        }
        PropertyAccessor comparableAccessor = accessor;
        columnWrapper.getComponent().setComparator(arg_0 -> ((PropertyAccessor)comparableAccessor).getPropertyValue(arg_0));
    }

    public Handler createUiUpdater(PropertyDispatcher propertyDispatcher, ComponentWrapper componentWrapper) {
        return Handler.NOP_HANDLER;
    }

    public boolean supports(WrapperType type) {
        return GridColumnWrapper.COLUMN_TYPE.isAssignableFrom(type);
    }
}

