/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.wrapper;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.dom.Element;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.Pattern;
import org.linkki.core.binding.Binding;
import org.linkki.core.binding.validation.message.Message;
import org.linkki.core.binding.validation.message.MessageList;
import org.linkki.core.binding.validation.message.Severity;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.binding.wrapper.WrapperType;

public abstract class VaadinComponentWrapper
implements ComponentWrapper {
    private static final String ATTRIBUTE_SEVERITY = "severity";
    private static final String PROPERTY_INVALID = "invalid";
    private static final String PROPERTY_ERROR_MESSAGE = "errorMessage";
    private static final Pattern REGEX_HTML_TAGS = Pattern.compile("<[^>]*>");
    private static final Pattern REGEX_BREAK_TAG = Pattern.compile("(?i)<br */?>");
    private static final long serialVersionUID = 1L;
    private final Component component;
    private final WrapperType type;

    public VaadinComponentWrapper(Component component, WrapperType type) {
        this.component = component;
        this.type = type;
        this.workaroundVaadinClientValidation();
    }

    private void workaroundVaadinClientValidation() {
        Component component = this.component;
        if (component instanceof HasClientValidation) {
            HasClientValidation fieldWithClientValidation = (HasClientValidation)component;
            fieldWithClientValidation.addClientValidatedEventListener((ComponentEventListener & Serializable)e -> {
                Element fieldElement = this.component.getElement();
                boolean invalid = fieldElement.getAttribute(ATTRIBUTE_SEVERITY) != null;
                Component patt3251$temp = this.component;
                if (patt3251$temp instanceof HasValue) {
                    HasValue hasValueComponent = (HasValue)patt3251$temp;
                    invalid |= hasValueComponent.isEmpty() && hasValueComponent.isRequiredIndicatorVisible();
                }
                fieldElement.setProperty(PROPERTY_INVALID, invalid);
            });
        }
    }

    public void setId(String id) {
        this.component.setId(id);
    }

    public void setEnabled(boolean enabled) {
        Component component = this.component;
        if (component instanceof HasEnabled) {
            HasEnabled field = (HasEnabled)component;
            field.setEnabled(enabled);
        }
    }

    public void setVisible(boolean visible) {
        this.component.setVisible(visible);
    }

    public void setTooltip(String text) {
        this.component.getElement().setAttribute("title", this.clearHtmlAndFormat(text));
    }

    public Component getComponent() {
        return this.component;
    }

    public void setValidationMessages(MessageList messagesForProperty) {
        Optional message = messagesForProperty.getMessageWithHighestSeverity();
        this.setErrorMessage(message.map(Message::getText).orElse(""));
        this.setInvalid(message.isPresent());
        this.setSeverity(message.map(Message::getSeverity).orElse(null));
    }

    private void setErrorMessage(String text) {
        Component component = this.component;
        if (component instanceof HasValidation) {
            HasValidation validationField = (HasValidation)component;
            validationField.setErrorMessage(text);
        } else {
            this.component.getElement().setProperty(PROPERTY_ERROR_MESSAGE, text);
        }
    }

    private void setInvalid(boolean invalid) {
        Component component = this.component;
        if (component instanceof HasValidation) {
            HasValidation validationField = (HasValidation)component;
            validationField.setInvalid(invalid);
        } else {
            this.component.getElement().setProperty(PROPERTY_INVALID, invalid);
        }
    }

    private void setSeverity(@CheckForNull Severity severity) {
        if (severity != null) {
            this.component.getElement().setAttribute(ATTRIBUTE_SEVERITY, severity.name().toLowerCase());
        } else {
            this.component.getElement().removeAttribute(ATTRIBUTE_SEVERITY);
        }
    }

    public void registerBinding(Binding binding) {
        if (ComponentUtil.getData((Component)this.component, Binding.class) != null) {
            throw new RuntimeException("Data was not empty, component was already bound");
        }
        ComponentUtil.setData((Component)this.component, Binding.class, (Object)binding);
    }

    public WrapperType getType() {
        return this.type;
    }

    private String clearHtmlAndFormat(@CheckForNull String text) {
        return Optional.ofNullable(text).map(html -> html.replaceAll(REGEX_BREAK_TAG.pattern(), "\n")).map(html -> html.replaceAll(REGEX_HTML_TAGS.pattern(), "")).orElse("");
    }
}

