/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.util;

import com.vaadin.flow.component.icon.Icon;
import java.util.Arrays;
import org.linkki.core.util.HtmlContentBuilder;

public final class HtmlContent {
    private final String content;

    HtmlContent(String content) {
        this.content = content;
    }

    public static HtmlContentBuilder builder() {
        return new HtmlContentBuilder();
    }

    public static HtmlContent sanitizeText(String htmlString) {
        return HtmlContent.builder().appendHtml(htmlString).build();
    }

    public static HtmlContent styledTag(String tag, String style, String content) {
        return HtmlContent.builder().styledTag(tag, style, content).build();
    }

    public static HtmlContent icon(Icon icon) {
        return HtmlContent.builder().icon(icon).build();
    }

    public static HtmlContent text(String text) {
        return HtmlContent.builder().text(text).build();
    }

    public static HtmlContent multilineText(String ... lines) {
        HtmlContentBuilder builder = HtmlContent.builder();
        Arrays.stream(lines).forEach(s -> {
            builder.text((String)s);
            builder.br();
        });
        return builder.build();
    }

    public String toString() {
        return this.content;
    }
}

