/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.util;

import com.vaadin.flow.component.icon.Icon;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.util.HtmlContent;
import org.linkki.core.util.HtmlSanitizer;

public final class HtmlContentBuilder {
    private final StringBuilder contentBuilder = new StringBuilder();

    public HtmlContentBuilder text(String text) {
        this.contentBuilder.append(HtmlSanitizer.escapeText(text));
        return this;
    }

    public HtmlContentBuilder tag(String tag) {
        return this.appendHtml(tag, Collections.emptyMap(), "");
    }

    public HtmlContentBuilder tag(String tag, Map<String, String> attributes) {
        return this.tag(tag, attributes, "");
    }

    public HtmlContentBuilder tag(String tag, String content) {
        return this.tag(tag, Collections.emptyMap(), content);
    }

    public HtmlContentBuilder tag(String tag, Map<String, String> attributes, HtmlContent content) {
        return this.appendHtml(tag, attributes, content);
    }

    public HtmlContentBuilder tag(String tag, Map<String, String> attributes, String content) {
        return this.appendHtml(tag, attributes, content);
    }

    public HtmlContentBuilder styledTag(String tag, String style, String content) {
        return this.tag(tag, Map.of("style", style), content);
    }

    public HtmlContentBuilder br() {
        return this.tag("br");
    }

    public HtmlContentBuilder icon(Icon icon) {
        return this.appendHtml(icon.getElement().getOuterHTML());
    }

    public HtmlContent build() {
        String sanitizedContent = HtmlSanitizer.sanitizeText(this.contentBuilder.toString());
        return new HtmlContent(sanitizedContent);
    }

    HtmlContentBuilder appendHtml(String html) {
        this.contentBuilder.append(html);
        return this;
    }

    private HtmlContentBuilder appendHtml(String tag, Map<String, String> attributes, Object content) {
        String html = this.buildHtml(tag, attributes, this.getHtmlString(content));
        this.contentBuilder.append(html);
        return this;
    }

    private String getHtmlString(Object content) {
        if (content instanceof String) {
            String string = (String)content;
            return HtmlSanitizer.escapeText(string);
        }
        return content.toString();
    }

    private String buildHtml(String tag, Map<String, String> attributes, String innerHtml) {
        String escapedTag = HtmlSanitizer.escapeText(tag);
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(escapedTag);
        attributes.entrySet().stream().map(entry -> " %s=\"%s\"".formatted(entry.getKey(), entry.getValue())).filter(attribute -> StringUtils.containsNone((CharSequence)attribute, (char[])new char[]{'<', '>'})).forEach(builder::append);
        builder.append(">");
        if (this.allowsContent(escapedTag)) {
            builder.append(innerHtml);
            builder.append("</");
            builder.append(escapedTag);
            builder.append(">");
        }
        return builder.toString();
    }

    private boolean allowsContent(String tag) {
        return !List.of("img", "br").contains(tag);
    }
}

