/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.util;

import com.vaadin.flow.component.icon.Icon;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;

public class HtmlSanitizer {
    private HtmlSanitizer() {
    }

    @CheckForNull
    public static String sanitizeText(@CheckForNull String htmlText) {
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        if (StringUtils.isEmpty((CharSequence)htmlText)) {
            return htmlText;
        }
        return Jsoup.clean((String)htmlText, (String)"", (Safelist)HtmlSanitizer.createHtmlWhitelist(), (Document.OutputSettings)outputSettings);
    }

    @CheckForNull
    public static String escapeText(@CheckForNull String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    private static Safelist createHtmlWhitelist() {
        String styleAttribute = "style";
        String classAttribute = "class";
        String idAttribute = "id";
        String vaadinIconTag = new Icon().getElement().getTag();
        return Safelist.basicWithImages().addTags(new String[]{vaadinIconTag}).addAttributes("div", new String[]{styleAttribute, classAttribute, idAttribute}).addAttributes("b", new String[]{styleAttribute}).addAttributes("span", new String[]{styleAttribute}).addAttributes("p", new String[]{styleAttribute}).addAttributes("em", new String[]{styleAttribute}).addAttributes("i", new String[]{styleAttribute}).addAttributes("strong", new String[]{styleAttribute}).addAttributes("u", new String[]{styleAttribute}).addAttributes(vaadinIconTag, new String[]{styleAttribute, classAttribute, idAttribute, "width", "height", "icon"}).removeProtocols("img", "src", new String[]{"http", "https"});
    }
}

