/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.vaadin.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.Autocomplete;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.component.timepicker.TimePicker;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.ui.LinkkiComponentUtil;
import org.linkki.core.uiframework.UiFramework;
import org.linkki.core.vaadin.component.DatePickerI18nCreator;
import org.linkki.core.vaadin.component.base.LinkkiAnchor;
import org.linkki.core.vaadin.component.base.LinkkiCheckBox;

public class ComponentFactory {
    public static final String NO_BREAK_SPACE = "&nbsp";
    public static final String AUTOSELECT = "autoselect";

    private ComponentFactory() {
    }

    public static Component newHorizontalLine() {
        Hr component = new Hr();
        component.setWidth("100%");
        return component;
    }

    public static LinkkiAnchor newLink(String caption) {
        LinkkiAnchor link = new LinkkiAnchor();
        link.setText(caption);
        return link;
    }

    public static TextField newTextField() {
        TextField textField = new TextField();
        textField.setAutocomplete(Autocomplete.OFF);
        return textField;
    }

    public static TextField newTextField(int maxLength, String width) {
        TextField field = ComponentFactory.newTextField();
        ComponentFactory.setMaxLengthAndWidth(field, maxLength, width);
        return field;
    }

    private static void setMaxLengthAndWidth(TextField field, int maxLength, String width) {
        if (maxLength > 0) {
            field.setMaxLength(maxLength);
            if (StringUtils.isEmpty((CharSequence)width)) {
                field.setWidth(maxLength + "em");
            } else {
                field.setWidth(width);
            }
        } else {
            field.setWidth(width);
        }
    }

    public static TextField newNumberField(int maxLength, String width, String pattern) {
        TextField field = ComponentFactory.newTextField(maxLength, width);
        field.addThemeVariants((ThemeVariant[])new TextFieldVariant[]{TextFieldVariant.LUMO_ALIGN_RIGHT});
        field.setAllowedCharPattern(pattern);
        return field;
    }

    public static TextField newNumberFieldWithFormattingPattern(int maxLength, String width, String pattern) {
        if (UiFramework.getLocale() == null) {
            throw new IllegalStateException("Creating a number field with a formatting pattern requires a UI with a locale");
        }
        DecimalFormat testFormatter = new DecimalFormat(pattern, new DecimalFormatSymbols(UiFramework.getLocale()));
        StringBuilder regexBuilder = new StringBuilder("[");
        testFormatter.format(-1234567890L).chars().forEach(regexBuilder::appendCodePoint);
        String enabledChars = regexBuilder.append("]").toString().replace(".", "\\.");
        return ComponentFactory.newNumberField(maxLength, width, enabledChars);
    }

    public static TextArea newTextArea() {
        TextArea textArea = new TextArea();
        LinkkiComponentUtil.preventEnterKeyPropagation((Component)textArea);
        return textArea;
    }

    public static TextArea newTextArea(int maxLength, String width, String height) {
        TextArea textArea = ComponentFactory.newTextArea();
        if (maxLength > 0) {
            textArea.setMaxLength(maxLength);
        }
        textArea.setWidth(width);
        if (!StringUtils.isEmpty((CharSequence)height)) {
            textArea.setHeight(height);
        }
        return textArea;
    }

    public static <T> ComboBox<T> newComboBox() {
        return new ComboBox();
    }

    public static <T> MultiSelectComboBox<T> newMultiSelect() {
        return new MultiSelectComboBox();
    }

    public static LinkkiCheckBox newCheckbox() {
        return new LinkkiCheckBox();
    }

    public static Button newButton() {
        return new Button();
    }

    public static DatePicker newDateField() {
        return ComponentFactory.newDateField(false, true);
    }

    public static DatePicker newDateField(boolean autoOpen, boolean autoselect) {
        if (UI.getCurrent() == null || UI.getCurrent().getLocale() == null) {
            throw new IllegalStateException("Creating a date field requires a UI with locale");
        }
        DatePicker field = new DatePicker();
        field.setI18n(DatePickerI18nCreator.createI18n(UI.getCurrent().getLocale()));
        field.setMin(LocalDate.ofYearDay(1000, 1));
        field.setMax(LocalDate.ofYearDay(9999, 365));
        field.setAutoOpen(autoOpen);
        field.getElement().setProperty(AUTOSELECT, autoselect);
        return field;
    }

    public static DateTimePicker newDateTimeField(long step) {
        return ComponentFactory.newDateTimeField(step, false, true);
    }

    public static DateTimePicker newDateTimeField(long step, boolean autoOpen, boolean autoselect) {
        if (UI.getCurrent() == null || UI.getCurrent().getLocale() == null) {
            throw new IllegalStateException("Creating a datetime field requires a UI with locale");
        }
        DateTimePicker field = new DateTimePicker();
        field.setDatePickerI18n(DatePickerI18nCreator.createI18n(UI.getCurrent().getLocale()));
        field.setMin(LocalDateTime.of(LocalDate.ofYearDay(1000, 1), LocalTime.of(0, 0)));
        field.setMax(LocalDateTime.of(LocalDate.ofYearDay(9999, 365), LocalTime.of(23, 59, 59)));
        field.setStep(Duration.ofMinutes(step));
        field.setAutoOpen(autoOpen);
        field.getElement().setProperty(AUTOSELECT, autoselect);
        return field;
    }

    public static TimePicker newTimeField(long step, ChronoUnit precision) {
        return ComponentFactory.newTimeField(step, precision, false, true);
    }

    public static TimePicker newTimeField(long step, ChronoUnit precision, boolean autoOpen, boolean autoselect) {
        if (UI.getCurrent() == null || UI.getCurrent().getLocale() == null) {
            throw new IllegalStateException("Creating a datetime field requires a UI with locale");
        }
        TimePicker field = new TimePicker();
        field.setMin(LocalTime.of(0, 0));
        field.setMax(LocalTime.of(23, 59, 59));
        field.setStep(ComponentFactory.getStepDuration(step, precision));
        field.setAutoOpen(autoOpen);
        field.getElement().setProperty(AUTOSELECT, autoselect);
        return field;
    }

    public static Button newButton(Icon icon, Collection<String> styleNames) {
        Button button = new Button((Component)icon);
        button.setTabIndex(-1);
        styleNames.forEach(arg_0 -> ((Button)button).addClassName(arg_0));
        return button;
    }

    public static VerticalLayout newPlainVerticalLayout() {
        VerticalLayout layout = new VerticalLayout();
        layout.setSpacing(false);
        layout.setMargin(false);
        return layout;
    }

    private static Duration getStepDuration(long step, ChronoUnit precision) {
        return switch (precision) {
            case ChronoUnit.SECONDS -> Duration.ofSeconds(step);
            case ChronoUnit.MINUTES -> Duration.ofMinutes(step);
            default -> throw new IllegalArgumentException("Unsupported ChronoUnit for step size");
        };
    }
}

