/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.vaadin.component;

import com.vaadin.flow.component.datepicker.DatePicker;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.format.TextStyle;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import org.linkki.core.nls.NlsService;
import org.linkki.util.DateFormats;

class DatePickerI18nCreator {
    private static final String BUNDLE_NAME = "org/linkki/core/vaadin/component/messages";

    private DatePickerI18nCreator() {
    }

    static DatePicker.DatePickerI18n createI18n(Locale locale) {
        DatePicker.DatePickerI18n i18n = new DatePicker.DatePickerI18n();
        DatePickerI18nCreator.initTexts(i18n, locale);
        i18n.setFirstDayOfWeek(DatePickerI18nCreator.getFirstDayOfWeek(locale));
        String pattern = DateFormats.getPattern((Locale)locale);
        String patternWithoutSeparators = pattern.replaceAll("[^a-zA-Z]", "");
        String patternWithoutSeparatorsShort = patternWithoutSeparators.replace("yyyy", "yy");
        i18n.setDateFormats(pattern, new String[]{patternWithoutSeparators, patternWithoutSeparatorsShort});
        return i18n;
    }

    private static int getFirstDayOfWeek(Locale locale) {
        if (!locale.getCountry().isEmpty()) {
            return WeekFields.of(locale).getFirstDayOfWeek().getValue() % 7;
        }
        return 1;
    }

    private static void initTexts(DatePicker.DatePickerI18n i18n, Locale locale) {
        DatePickerI18nCreator.getText("cancel", locale).ifPresent(arg_0 -> ((DatePicker.DatePickerI18n)i18n).setCancel(arg_0));
        DatePickerI18nCreator.getText("today", locale).ifPresent(arg_0 -> ((DatePicker.DatePickerI18n)i18n).setToday(arg_0));
        ArrayList<String> weekdays = new ArrayList<String>(7);
        ArrayList<String> weekdaysShort = new ArrayList<String>(7);
        for (int i = 0; i < 7; ++i) {
            DayOfWeek day = DayOfWeek.of(i != 0 ? i : 7);
            weekdays.add(day.getDisplayName(TextStyle.FULL_STANDALONE, locale));
            weekdaysShort.add(day.getDisplayName(TextStyle.SHORT_STANDALONE, locale));
        }
        i18n.setWeekdays(weekdays);
        i18n.setWeekdaysShort(weekdaysShort);
        ArrayList<String> months = new ArrayList<String>(12);
        for (Month month : Month.values()) {
            months.add(month.getDisplayName(TextStyle.FULL_STANDALONE, locale));
        }
        i18n.setMonthNames(months);
    }

    private static Optional<String> getText(String key, Locale locale) {
        return NlsService.get().getString(BUNDLE_NAME, DatePickerI18nCreator.class.getSimpleName() + "." + key, locale);
    }
}

