/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.vaadin.component.base;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.dom.PropertyChangeListener;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Predicate;

public class LabelComponentFormItem
extends FormLayout.FormItem {
    private static final long serialVersionUID = 1L;
    private final NativeLabel label;
    private final Component component;

    public LabelComponentFormItem(Component component, String label) {
        this(component, new NativeLabel(Objects.requireNonNull(label, "label must not be null")));
    }

    public LabelComponentFormItem(Component component, NativeLabel label) {
        this.component = Objects.requireNonNull(component, "component must not be null");
        this.label = Objects.requireNonNull(label, "label must not be null");
        this.add(new Component[]{component});
        this.addToLabel(new Component[]{label});
        if (component instanceof HasValue) {
            this.synchronizePropertyFromField(component, "readonly", HasValue::isReadOnly);
            if (component instanceof RadioButtonGroup) {
                component.getElement().addPropertyChangeListener("disabled", (PropertyChangeListener & Serializable)e -> this.getElement().setAttribute("readonly", ((RadioButtonGroup)component).isReadOnly()));
            }
        }
    }

    private void synchronizePropertyFromField(Component cmpt, String attribute, Predicate<HasValue<?, ?>> valueOfField) {
        HasValue field = (HasValue)cmpt;
        this.getElement().setAttribute(attribute, valueOfField.test(field));
        cmpt.getElement().addPropertyChangeListener(attribute, (PropertyChangeListener & Serializable)e -> this.getElement().setAttribute(attribute, valueOfField.test(field)));
    }

    public Component getComponent() {
        return this.component;
    }

    public NativeLabel getLabel() {
        return this.label;
    }

    public void setLabel(String text) {
        this.label.setText(text);
    }

    public String toString() {
        return this.label.getText() + "(" + this.getComponent().getClass().getSimpleName() + ")";
    }
}

