/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.vaadin.component.page;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import edu.umd.cs.findbugs.annotations.OverrideMustInvoke;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.Objects;
import org.linkki.core.binding.BindingContext;
import org.linkki.core.binding.manager.BindingManager;
import org.linkki.core.ui.creation.section.PmoBasedSectionFactory;
import org.linkki.core.vaadin.component.page.Page;
import org.linkki.core.vaadin.component.section.LinkkiSection;

@CssImport(value="./styles/linkki-page.css")
public abstract class AbstractPage
extends VerticalLayout
implements Page {
    private static final long serialVersionUID = 1L;
    private final PmoBasedSectionFactory sectionFactory;

    public AbstractPage() {
        this(new PmoBasedSectionFactory());
    }

    public AbstractPage(PmoBasedSectionFactory sectionFactory) {
        this.sectionFactory = Objects.requireNonNull(sectionFactory, "sectionFactory must not be null");
        this.addClassName("linkki-page");
        this.setPadding(true);
    }

    @PostConstruct
    @OverrideMustInvoke
    public final void init() {
        this.createContent();
    }

    public PmoBasedSectionFactory getPmoBasedSectionFactory() {
        return this.sectionFactory;
    }

    protected LinkkiSection addSection(Object pmo) {
        LinkkiSection section = this.sectionFactory.createSection(pmo, this.getBindingContext());
        this.add(new Component[]{section});
        return section;
    }

    protected void addSections(Object ... pmos) {
        this.addHorizontally((Component[])Arrays.stream(pmos).map(pmo -> this.sectionFactory.createSection(pmo, this.getBindingContext())).toArray(LinkkiSection[]::new));
    }

    public void addHorizontally(Component ... sections) {
        HorizontalLayout wrapper = new HorizontalLayout();
        wrapper.setWidth("100%");
        wrapper.setSpacing(true);
        this.add(new Component[]{wrapper});
        wrapper.addAndExpand(sections);
    }

    @Override
    @OverrideMustInvoke
    public void reloadBindings() {
        this.getBindingContext().uiUpdated();
    }

    protected abstract BindingManager getBindingManager();

    protected BindingContext getBindingContext() {
        return this.getBindingManager().getContext(this.getClass());
    }
}

