/*
 * Copyright Faktor Zehn GmbH.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing permissions and limitations under the
 * License.
 */

package org.linkki.ips.binding.dispatcher;

import org.linkki.core.binding.descriptor.property.BoundProperty;
import org.linkki.core.binding.dispatcher.PropertyDispatcher;
import org.linkki.core.binding.dispatcher.PropertyDispatcherFactory;

/**
 * A {@link PropertyDispatcherFactory} that wraps the standard dispatchers in an
 * {@link IpsPropertyDispatcher}.
 */
public class IpsPropertyDispatcherFactory extends PropertyDispatcherFactory {

    @Override
    protected PropertyDispatcher createCustomDispatchers(Object pmo,
            BoundProperty boundProperty,
            PropertyDispatcher standardDispatchers) {
        return IpsPropertyDispatcher.createIpsPropertyDispatcher(pmo, boundProperty, standardDispatchers);
    }
}
