/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.luava.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.linuxprobe.luava.http.IdleConnectionEvictor;
import org.linuxprobe.luava.http.Qs;
import org.linuxprobe.luava.json.JacksonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpRequestUtils.class);
    private volatile CloseableHttpClient httpClient;
    private ConnectPool connectPool;

    public HttpRequestUtils(ConnectPool connectPool) {
        if (connectPool == null) {
            connectPool = new ConnectPool();
        }
        this.connectPool = connectPool;
    }

    public HttpRequestUtils() {
    }

    public CloseableHttpResponse getRequest(String url, Header ... headers) {
        if (logger.isTraceEnabled()) {
            logger.trace("\u672c\u6b21\u8bf7\u6c42\u5730\u5740:" + url);
        }
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpGet httpGet = new HttpGet(url);
        if (headers != null && headers.length != 0) {
            httpGet.setHeaders(headers);
        }
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public CloseableHttpResponse getRequest(String url) {
        return this.getRequest(url, null);
    }

    public CloseableHttpResponse getRequest(String url, Object urlParams, Header ... headers) {
        if (urlParams != null) {
            String urlParam = Qs.stringify(urlParams);
            url = url.indexOf("?") != -1 ? url + "&" + urlParam : url + "?" + urlParam;
        }
        return this.getRequest(url, headers);
    }

    public CloseableHttpResponse getRequest(String url, Object urlParams) {
        return this.getRequest(url, urlParams, (Header[])null);
    }

    public CloseableHttpResponse deleteRequest(String url, Header ... headers) {
        if (logger.isTraceEnabled()) {
            logger.trace("\u672c\u6b21\u8bf7\u6c42\u5730\u5740:" + url);
        }
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpDelete httpDelete = new HttpDelete(url);
        if (headers != null && headers.length != 0) {
            httpDelete.setHeaders(headers);
        }
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpDelete);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public CloseableHttpResponse deleteRequest(String url) {
        return this.deleteRequest(url, null);
    }

    public CloseableHttpResponse deleteRequest(String url, Object urlParams, Header ... headers) {
        if (urlParams != null) {
            String urlParam = Qs.stringify(urlParams);
            url = url.indexOf("?") != -1 ? url + "&" + urlParam : url + "?" + urlParam;
        }
        return this.deleteRequest(url, headers);
    }

    public CloseableHttpResponse deleteRequest(String url, Object urlParams) {
        return this.deleteRequest(url, urlParams, (Header[])null);
    }

    public CloseableHttpResponse headRequest(String url, Header ... headers) {
        if (logger.isTraceEnabled()) {
            logger.trace("\u672c\u6b21\u8bf7\u6c42\u5730\u5740:" + url);
        }
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpHead httpHead = new HttpHead(url);
        if (headers != null && headers.length != 0) {
            httpHead.setHeaders(headers);
        }
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpHead);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public CloseableHttpResponse headRequest(String url) {
        return this.headRequest(url, null);
    }

    public CloseableHttpResponse headRequest(String url, Object urlParams, Header ... headers) {
        if (urlParams != null) {
            String urlParam = Qs.stringify(urlParams);
            url = url.indexOf("?") != -1 ? url + "&" + urlParam : url + "?" + urlParam;
        }
        return this.headRequest(url, headers);
    }

    public CloseableHttpResponse headRequest(String url, Object urlParams) {
        return this.headRequest(url, urlParams, (Header[])null);
    }

    public CloseableHttpResponse optionsRequest(String url, Header ... headers) {
        if (logger.isTraceEnabled()) {
            logger.trace("\u672c\u6b21\u8bf7\u6c42\u5730\u5740:" + url);
        }
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpOptions httpOptions = new HttpOptions(url);
        if (headers != null && headers.length != 0) {
            httpOptions.setHeaders(headers);
        }
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpOptions);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public CloseableHttpResponse optionsRequest(String url) {
        return this.optionsRequest(url, null);
    }

    public CloseableHttpResponse optionsRequest(String url, Object urlParams, Header ... headers) {
        if (urlParams != null) {
            String urlParam = Qs.stringify(urlParams);
            url = url.indexOf("?") != -1 ? url + "&" + urlParam : url + "?" + urlParam;
        }
        return this.optionsRequest(url, headers);
    }

    public CloseableHttpResponse optionsRequest(String url, Object urlParams) {
        return this.optionsRequest(url, urlParams, (Header[])null);
    }

    public CloseableHttpResponse postRequest(String url, Object urlParams, Object bodyParam, Header ... headers) {
        if (urlParams != null) {
            String urlParam = Qs.stringify(urlParams);
            url = url.indexOf("?") != -1 ? url + "&" + urlParam : url + "?" + urlParam;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("\u672c\u6b21\u8bf7\u6c42\u5730\u5740:" + url);
        }
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        if (headers != null && headers.length != 0) {
            httpPost.setHeaders(headers);
        }
        if (bodyParam != null) {
            if (bodyParam instanceof HttpEntity) {
                if (logger.isTraceEnabled()) {
                    logger.trace("\u672c\u6b21\u8bf7\u6c42body\u53c2\u6570:" + bodyParam);
                }
                httpPost.setEntity((HttpEntity)bodyParam);
            } else {
                String bodyStr = null;
                bodyStr = bodyParam instanceof String ? (String)bodyParam : (bodyParam instanceof StringBuilder || bodyParam instanceof StringBuffer ? bodyParam.toString() : JacksonUtils.toJsonString((Object)bodyParam));
                if (logger.isTraceEnabled()) {
                    logger.trace("\u672c\u6b21\u8bf7\u6c42body\u53c2\u6570:" + bodyStr);
                }
                httpPost.setEntity((HttpEntity)new StringEntity(bodyStr, ContentType.APPLICATION_JSON));
            }
        }
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public CloseableHttpResponse postRequest(String url, Object urlParams, Object bodyParam) {
        return this.postRequest(url, urlParams, bodyParam, (Header[])null);
    }

    public CloseableHttpResponse postRequest(String url, Object bodyParam, Header ... headers) {
        return this.postRequest(url, null, bodyParam, headers);
    }

    public CloseableHttpResponse postRequest(String url, Object bodyParam) {
        return this.postRequest(url, null, bodyParam);
    }

    public CloseableHttpResponse postRequest(Object urlParams, String url, Header ... headers) {
        return this.postRequest(url, urlParams, (Object)null, headers);
    }

    public CloseableHttpResponse postRequest(Object urlParams, String url) {
        return this.postRequest(url, urlParams, (Object)null, (Header[])null);
    }

    public CloseableHttpResponse postRequest(String url, Header ... headers) {
        return this.postRequest(url, (Object)null, (Object)null, headers);
    }

    public CloseableHttpResponse postRequest(String url) {
        return this.postRequest(url, (Object)null, (Object)null, (Header[])null);
    }

    public CloseableHttpResponse putRequest(String url, Object urlParams, Object bodyParam, Header ... headers) {
        if (urlParams != null) {
            String urlParam = Qs.stringify(urlParams);
            url = url.indexOf("?") != -1 ? url + "&" + urlParam : url + "?" + urlParam;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("\u672c\u6b21\u8bf7\u6c42\u5730\u5740:" + url);
        }
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpPut httpPut = new HttpPut(url);
        if (headers != null && headers.length != 0) {
            httpPut.setHeaders(headers);
        }
        if (bodyParam != null) {
            if (bodyParam instanceof HttpEntity) {
                if (logger.isTraceEnabled()) {
                    logger.trace("\u672c\u6b21\u8bf7\u6c42body\u53c2\u6570:" + bodyParam);
                }
                httpPut.setEntity((HttpEntity)bodyParam);
            } else {
                String bodyStr = null;
                bodyStr = bodyParam instanceof String ? (String)bodyParam : (bodyParam instanceof StringBuilder || bodyParam instanceof StringBuffer ? bodyParam.toString() : JacksonUtils.toJsonString((Object)bodyParam));
                if (logger.isTraceEnabled()) {
                    logger.trace("\u672c\u6b21\u8bf7\u6c42body\u53c2\u6570:" + bodyStr);
                }
                httpPut.setEntity((HttpEntity)new StringEntity(bodyStr, ContentType.APPLICATION_JSON));
            }
        }
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPut);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public CloseableHttpResponse putRequest(String url, Object urlParams, Object bodyParam) {
        return this.putRequest(url, urlParams, bodyParam, (Header[])null);
    }

    public CloseableHttpResponse putRequest(String url, Object bodyParam, Header ... headers) {
        return this.putRequest(url, null, bodyParam, headers);
    }

    public CloseableHttpResponse putRequest(String url, Object bodyParam) {
        return this.putRequest(url, null, bodyParam);
    }

    public CloseableHttpResponse putRequest(Object urlParams, String url, Header ... headers) {
        return this.putRequest(url, urlParams, (Object)null, headers);
    }

    public CloseableHttpResponse putRequest(Object urlParams, String url) {
        return this.putRequest(url, urlParams, (Object)null, (Header[])null);
    }

    public CloseableHttpResponse putRequest(String url, Header ... headers) {
        return this.putRequest(url, (Object)null, (Object)null, headers);
    }

    public CloseableHttpResponse putRequest(String url) {
        return this.putRequest(url, (Object)null, (Object)null, (Header[])null);
    }

    public static <T> T responseDataConversion(HttpResponse response, Class<T> type) {
        if (response == null) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        String entityString = null;
        try {
            entityString = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException | ParseException e1) {
            throw new RuntimeException(e1);
        }
        Object result = null;
        result = JacksonUtils.conversion((Object)entityString, type);
        try {
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    private HttpRequestRetryHandler createHttpRequestRetryHandler() {
        HttpRequestRetryHandler httpRequestRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= 3) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return false;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        return httpRequestRetryHandler;
    }

    private HttpClientConnectionManager createClientConnectionManager() {
        PoolingHttpClientConnectionManager clientConnectionManager = null;
        SSLContext sslContext = null;
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
        clientConnectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        clientConnectionManager.setMaxTotal(this.connectPool.getAllMaxActive());
        clientConnectionManager.setDefaultMaxPerRoute(this.connectPool.getSingleMaxActive());
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoReuseAddress(true).setSoTimeout(this.connectPool.getSocketTimeout()).setSoLinger(6).setSoKeepAlive(true).build();
        clientConnectionManager.setDefaultSocketConfig(socketConfig);
        return clientConnectionManager;
    }

    private RequestConfig createRequestConfig() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectPool.getConnectTimeout()).setSocketTimeout(this.connectPool.getSocketTimeout()).setConnectionRequestTimeout(this.connectPool.getConnectionRequestTimeout()).build();
        return requestConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableHttpClient getHttpClient() {
        if (this.connectPool == null) {
            return HttpClients.createDefault();
        }
        if (this.httpClient == null) {
            HttpRequestUtils httpRequestUtils = this;
            synchronized (httpRequestUtils) {
                if (this.httpClient == null) {
                    HttpClientConnectionManager clientConnectionManager = this.createClientConnectionManager();
                    this.httpClient = HttpClients.custom().setConnectionManager(clientConnectionManager).setDefaultRequestConfig(this.createRequestConfig()).setRetryHandler(this.createHttpRequestRetryHandler()).build();
                    IdleConnectionEvictor idleConnectionEvictor = new IdleConnectionEvictor(clientConnectionManager, this.connectPool.getMaxLifetime(), this.connectPool.getCleanSleepTimeMs());
                    idleConnectionEvictor.start();
                }
            }
        }
        return this.httpClient;
    }

    public void close() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
                this.httpClient = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void finalize() {
        this.close();
    }

    public static class ConnectPool {
        private static final int defaultConnectTimeout = 5000;
        private static final int defaultSocketTimeout = 10000;
        private static final int defaultConnectionRequestTimeout = 20000;
        private static final int defaultSingleMaxActive = 5;
        private static final int defaultAllMaxActive = 40;
        private static final long defaultMaxLifetime = 1800000L;
        private static final long defaultCleanSleepTimeMs = 30000L;
        private int connectTimeout = 5000;
        private int socketTimeout = 10000;
        private int connectionRequestTimeout = 20000;
        private int singleMaxActive = 5;
        private int allMaxActive = 40;
        private long maxLifetime = 1800000L;
        private long cleanSleepTimeMs = 30000L;

        public ConnectPool setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ConnectPool setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public ConnectPool setConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public ConnectPool setSingleMaxActive(int singleMaxActive) {
            this.singleMaxActive = singleMaxActive;
            return this;
        }

        public ConnectPool setAllMaxActive(int allMaxActive) {
            this.allMaxActive = allMaxActive;
            return this;
        }

        public ConnectPool setMaxLifetime(long maxLifetime) {
            this.maxLifetime = maxLifetime;
            return this;
        }

        public ConnectPool setCleanSleepTimeMs(long cleanSleepTimeMs) {
            this.cleanSleepTimeMs = cleanSleepTimeMs;
            return this;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public int getSocketTimeout() {
            return this.socketTimeout;
        }

        public int getConnectionRequestTimeout() {
            return this.connectionRequestTimeout;
        }

        public int getSingleMaxActive() {
            return this.singleMaxActive;
        }

        public int getAllMaxActive() {
            return this.allMaxActive;
        }

        public long getMaxLifetime() {
            return this.maxLifetime;
        }

        public long getCleanSleepTimeMs() {
            return this.cleanSleepTimeMs;
        }
    }
}

